/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.sdk.unified.log;

import com.huawei.ism.tool.sdk.unified.log.exception.UnifiedLogException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.plugins.util.PluginManager;

public class UnifiedLogConfigurator {
    private static final String RES_FORMAT = "jar:%s!/%s";
    private static final String DEFAULT_CONFIG_NAME = "log4j2.xml";

    public static void initializeWithConfig(ClassLoader classLoader, InputStream input) throws UnifiedLogException {
        PluginManager.addPackage((String)"com.huawei.ism.tool.sdk.unified.log");
        org.apache.logging.log4j.spi.LoggerContext context = LogManager.getContext((ClassLoader)classLoader, (boolean)false);
        if (context instanceof LoggerContext) {
            LoggerContext actualContext = (LoggerContext)context;
            try {
                actualContext.start(ConfigurationFactory.getInstance().getConfiguration(actualContext, new ConfigurationSource(input)));
            }
            catch (Exception exception) {
                throw new UnifiedLogException("initialize logger context with given configuration input failed", exception);
            }
        } else {
            throw new UnifiedLogException("logger context type mismatch, expected: " + LoggerContext.class + ", actual: " + context.getClass());
        }
    }

    public static void initializeWithDefaultConfig() throws UnifiedLogException {
        UnifiedLogConfigurator.initializeWithDefaultConfig(null);
    }

    public static void initializeWithDefaultConfig(ClassLoader classLoader) throws UnifiedLogException {
        try {
            String location = UnifiedLogConfigurator.class.getProtectionDomain().getCodeSource().getLocation().toString();
            String targetResource = String.format(Locale.ROOT, RES_FORMAT, location, DEFAULT_CONFIG_NAME);
            Enumeration<URL> resources = UnifiedLogConfigurator.class.getClassLoader().getResources(DEFAULT_CONFIG_NAME);
            UnifiedLogConfigurator.findResourceAndInitialize(classLoader, resources, targetResource);
        }
        catch (Exception exception) {
            throw new UnifiedLogException("initialize logger context with default config failed", exception);
        }
    }

    private static void findResourceAndInitialize(ClassLoader classLoader, Enumeration<URL> resources, String targetResource) throws IOException, UnifiedLogException {
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            if (!targetResource.equals(url.toString())) continue;
            try (InputStream input = url.openStream();){
                UnifiedLogConfigurator.initializeWithConfig(classLoader, input);
                return;
            }
        }
    }

    private UnifiedLogConfigurator() {
    }
}

