/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.connect.impl;

import org.camunda.connect.ConnectorException;
import org.camunda.connect.impl.ConnectLogger;
import org.camunda.connect.spi.CloseableConnectorResponse;
import org.camunda.connect.spi.Connector;
import org.camunda.connect.spi.ConnectorConfigurator;
import org.camunda.connect.spi.ConnectorProvider;

public class ConnectCoreLogger
extends ConnectLogger {
    public void closingResponse(CloseableConnectorResponse response) {
        this.logDebug("001", "Closing closeable connector response '{}'", new Object[]{response});
    }

    public void successfullyClosedResponse(CloseableConnectorResponse response) {
        this.logDebug("002", "Successfully closed closeable connector response '{}'", new Object[]{response});
    }

    public ConnectorException exceptionWhileClosingResponse(Exception cause) {
        return new ConnectorException(this.exceptionMessage("003", "Unable to close response", new Object[0]), cause);
    }

    public void connectorProviderDiscovered(ConnectorProvider provider, String connectorId, Connector connectorInstance) {
        if (this.isInfoEnabled()) {
            this.logInfo("004", "Discovered provider for connector id '{}' and class '{}': '{}'", new Object[]{connectorId, connectorInstance.getClass().getName(), provider.getClass().getName()});
        }
    }

    public ConnectorException multipleConnectorProvidersFound(String connectorId) {
        return new ConnectorException(this.exceptionMessage("005", "Multiple providers found for connector '{}'", new Object[]{connectorId}));
    }

    public void connectorConfiguratorDiscovered(ConnectorConfigurator configurator) {
        if (this.isInfoEnabled()) {
            this.logInfo("006", "Discovered configurator for connector class '{}': '{}'", new Object[]{configurator.getConnectorClass().getName(), configurator.getClass().getName()});
        }
    }
}

