/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.embedded;

import com.alicp.jetcache.embedded.LinkedHashMapCache;
import com.alicp.jetcache.support.JetCacheExecutor;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

class Cleaner {
    static LinkedList<WeakReference<LinkedHashMapCache>> linkedHashMapCaches = new LinkedList();
    private static final ReentrantLock reentrantLock = new ReentrantLock();

    Cleaner() {
    }

    static void add(LinkedHashMapCache cache) {
        reentrantLock.lock();
        try {
            linkedHashMapCaches.add(new WeakReference<LinkedHashMapCache>(cache));
        }
        finally {
            reentrantLock.unlock();
        }
    }

    static void run() {
        reentrantLock.lock();
        try {
            Iterator it = linkedHashMapCaches.iterator();
            while (it.hasNext()) {
                WeakReference ref = (WeakReference)it.next();
                LinkedHashMapCache c = (LinkedHashMapCache)ref.get();
                if (c == null) {
                    it.remove();
                    continue;
                }
                c.cleanExpiredEntry();
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    static {
        ScheduledExecutorService executorService = JetCacheExecutor.defaultExecutor();
        executorService.scheduleWithFixedDelay(() -> Cleaner.run(), 60L, 60L, TimeUnit.SECONDS);
    }
}

