/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.template;

import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheBuilder;
import com.alicp.jetcache.CacheManager;
import com.alicp.jetcache.CacheUtil;
import com.alicp.jetcache.MultiLevelCache;
import com.alicp.jetcache.external.ExternalCacheBuilder;
import com.alicp.jetcache.support.BroadcastManager;
import com.alicp.jetcache.support.CacheNotifyMonitor;
import com.alicp.jetcache.template.CacheMonitorInstaller;
import com.alicp.jetcache.template.QuickConfig;
import java.util.function.Function;

public class NotifyMonitorInstaller
implements CacheMonitorInstaller {
    private final Function<String, CacheBuilder> remoteBuilderTemplate;

    public NotifyMonitorInstaller(Function<String, CacheBuilder> remoteBuilderTemplate) {
        this.remoteBuilderTemplate = remoteBuilderTemplate;
    }

    @Override
    public void addMonitors(CacheManager cacheManager, Cache cache, QuickConfig quickConfig) {
        BroadcastManager cm;
        if (quickConfig.getSyncLocal() == null || !quickConfig.getSyncLocal().booleanValue()) {
            return;
        }
        if (!(CacheUtil.getAbstractCache(cache) instanceof MultiLevelCache)) {
            return;
        }
        String area = quickConfig.getArea();
        ExternalCacheBuilder cacheBuilder = (ExternalCacheBuilder)this.remoteBuilderTemplate.apply(area);
        if (cacheBuilder == null || !cacheBuilder.supportBroadcast() || cacheBuilder.getConfig().getBroadcastChannel() == null) {
            return;
        }
        if (cacheManager.getBroadcastManager(area) == null && (cm = cacheBuilder.createBroadcastManager(cacheManager)) != null) {
            cm.startSubscribe();
            cacheManager.putBroadcastManager(area, cm);
        }
        CacheNotifyMonitor monitor = new CacheNotifyMonitor(cacheManager, area, quickConfig.getName());
        cache.config().getMonitors().add(monitor);
    }
}

