/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dmedata.deploytoolprovider;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.dmedata.deploytoolprovider.common.CommonUtils;
import com.huawei.dmedata.deploytoolprovider.common.DmeProviderException;
import com.huawei.dmedata.deploytoolprovider.deploy.ClearEnvironment;
import com.huawei.dmedata.deploytoolprovider.deploy.ConfigDeployParams;
import com.huawei.dmedata.deploytoolprovider.deploy.DeployProjectAction;
import com.huawei.dmedata.deploytoolprovider.deploy.InitParamTemplate;
import com.huawei.dmedata.deploytoolprovider.deploy.InstallProgress;
import com.huawei.dmedata.deploytoolprovider.deploy.LoadDeployTool;
import com.huawei.dmedata.deploytoolprovider.deploy.SubTaskOperation;
import com.huawei.dmedata.deploytoolprovider.model.DeployUpdateParam;
import com.huawei.dmedata.deploytoolprovider.model.DmeParamTemplate;
import com.huawei.dmedata.deploytoolprovider.model.DmeProgress;
import com.huawei.dmedata.deploytoolprovider.model.FcUpdateParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployProvider {
    private static final Logger log = LoggerFactory.getLogger(DeployProvider.class);
    private static Integer projectId = -1;
    private static final int UNINSTALL_RETRY_TIMES = 3;

    public static void initProject(String deployToolsPath) throws DmeProviderException {
        if (projectId.equals(-1)) {
            projectId = ConfigDeployParams.initProject(deployToolsPath);
        }
    }

    public static List<DmeParamTemplate> getParamTemplate(String deployFilePath) throws DmeProviderException {
        return InitParamTemplate.getParamTemplateBo(deployFilePath);
    }

    public static List<String> getCanSkipSubTaskKeys() {
        return new ArrayList<String>();
    }

    public static void setConfigParam(Map<String, String> params, String deployFilePath) throws DmeProviderException {
        DeployProvider.initTenantParams(params);
        DeployProvider.checkProjectId();
        List<DeployUpdateParam> parameters = InitParamTemplate.getParamTemplate(deployFilePath);
        for (Map.Entry<String, String> param : params.entrySet()) {
            DeployProvider.setDeployUpdateParam(parameters, param.getKey(), param.getValue());
        }
        List<FcUpdateParam> FcParameters = DeployProvider.getFcParams(params);
        ConfigDeployParams.setConfigParam(projectId, parameters);
        ConfigDeployParams.updateFcParams(projectId, FcParameters);
    }

    private static void initTenantParams(Map<String, String> params) {
        if (Objects.equals(params.get("DMEData_deploy_tenant"), "YES")) {
            return;
        }
        params.put("DMEData_deploy_backup", "NO");
        params.put("DMEData_auth_type", "POE");
        params.put("DMEData_sdn_scene", "type2");
    }

    private static List<FcUpdateParam> getFcParams(Map<String, String> info) throws DmeProviderException {
        ArrayList<FcUpdateParam> result = new ArrayList<FcUpdateParam>();
        for (Map.Entry<String, String> entry : info.entrySet()) {
            if (!entry.getKey().contains("FC_")) continue;
            FcUpdateParam elem = new FcUpdateParam();
            elem.setParamId(ConfigDeployParams.getParamId(projectId, entry.getKey().replace("DMEData_", "")));
            elem.setParamKey(entry.getKey().replace("DMEData_", ""));
            elem.setParamValue(entry.getValue());
            if (entry.getKey().contains("password")) {
                elem.setEncrypted(true);
            }
            result.add(elem);
        }
        return result;
    }

    private static void setDeployUpdateParam(List<DeployUpdateParam> parameters, String key, String value) throws DmeProviderException {
        JSONObject templateJson = CommonUtils.getTemplateFileJson("/template.json");
        JSONArray keysReplacement = templateJson.getJSONArray("keysReplacement");
        for (DeployUpdateParam param : parameters) {
            String targetKey = DeployProvider.handleKeysReplacement(key, keysReplacement);
            if (CommonUtils.isEmpty(key) || !targetKey.equals(param.getParamKey()) && !key.equals(param.getParamKey())) continue;
            param.setParamValue(value);
            if (key.equals(param.getParamKey())) continue;
            param.setParamKey(targetKey);
            return;
        }
    }

    private static String handleKeysReplacement(String key, JSONArray keysReplacements) {
        if (CommonUtils.isEmpty(key) || keysReplacements == null || keysReplacements.size() == 0) {
            log.error("keysReplacement config param not exist.");
            return key;
        }
        for (int index = 0; index < keysReplacements.size(); ++index) {
            JSONObject keysReplacement = keysReplacements.getJSONObject(index);
            if (keysReplacement.keySet().size() == 0 || !key.equals(keysReplacement.values().toArray()[0].toString())) continue;
            return keysReplacement.keySet().toArray()[0].toString();
        }
        return key;
    }

    public static void resetEnvironment() throws DmeProviderException {
        DeployProvider.checkProjectId();
        ClearEnvironment.clear();
    }

    public static void start() throws DmeProviderException {
        DeployProvider.checkProjectId();
        DeployProjectAction.start(projectId);
    }

    public static void stop() throws DmeProviderException {
        DeployProvider.checkProjectId();
        DeployProjectAction.stop(projectId);
    }

    public static List<DmeProgress> getTaskProgress() throws DmeProviderException {
        DeployProvider.checkProjectId();
        return InstallProgress.getInstallProgress(projectId);
    }

    public static void skipTask(String taskId, String subtaskId) throws DmeProviderException {
        DeployProvider.checkProjectId();
        SubTaskOperation.skip(projectId, taskId, subtaskId);
    }

    public static void retry(String taskId, String subtaskId) throws DmeProviderException {
        DeployProvider.checkProjectId();
        SubTaskOperation.retry(projectId, taskId, subtaskId);
    }

    public static void submitProject() throws DmeProviderException {
        DeployProvider.checkProjectId();
        DeployProjectAction.commit(projectId);
    }

    public static void uninstall(String deployFilePath) throws DmeProviderException {
        log.info("smartKit path param:{}", (Object)deployFilePath);
        ConfigDeployParams.changeStatusOfIoSkip(deployFilePath, "false");
        boolean interfaceStatus = true;
        for (int retryTimes = 0; retryTimes < 3 && interfaceStatus; ++retryTimes) {
            LoadDeployTool.executeUninstallBat(deployFilePath);
            interfaceStatus = DeployProvider.retryCheckHealthInterfaceInvalid();
            log.info("interface health status :{}", (Object)interfaceStatus);
        }
        if (interfaceStatus) {
            throw new DmeProviderException("uninstall failed.");
        }
        projectId = -1;
    }

    private static void checkProjectId() throws DmeProviderException {
        if (projectId == -1) {
            log.error("project not init.");
            throw new DmeProviderException("project not init.");
        }
    }

    private static boolean retryCheckHealthInterfaceInvalid() {
        boolean interfaceStatus = true;
        int interfaceRetryTimes = 10;
        for (int retryTimes = 0; retryTimes < interfaceRetryTimes && interfaceStatus; ++retryTimes) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                log.error("sleep exception:{}", (Object)ex.getMessage());
            }
            interfaceStatus = ConfigDeployParams.checkHealth();
        }
        return interfaceStatus;
    }
}

