/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dmedata.deploytoolprovider.common;

import com.huawei.dmedata.deploytoolprovider.common.DmeProviderException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmdOperation {
    private static final Logger log = LoggerFactory.getLogger(CmdOperation.class);

    public static String cuteCmd(String command, boolean isCloseWindow) throws DmeProviderException {
        return CmdOperation.cuteCmd(command, isCloseWindow, null);
    }

    public static String cuteCmd(String command, boolean isCloseWindow, File dir) throws DmeProviderException {
        String errorMessage;
        Runtime runtime = Runtime.getRuntime();
        try {
            String finalCommand = isCloseWindow ? "cmd /c " + command : "cmd /k " + command;
            Process process = runtime.exec(finalCommand, null, dir);
            errorMessage = CmdOperation.consumeInputStream(process.getErrorStream());
            String inputMessage = CmdOperation.consumeInputStream(process.getInputStream());
            log.info("exec input message:{}", (Object)inputMessage);
            process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            throw new DmeProviderException("exec exe failed.");
        }
        log.error("exec error message:{}", (Object)errorMessage);
        return errorMessage;
    }

    private static String consumeInputStream(InputStream inputStream) throws IOException {
        String result;
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder sb = new StringBuilder();
        while ((result = br.readLine()) != null) {
            sb.append(result);
        }
        return sb.toString();
    }
}

