/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dmedata.deploytoolprovider.common.http;

import com.huawei.dmedata.deploytoolprovider.common.CommonUtils;
import com.huawei.dmedata.deploytoolprovider.common.DmeProviderException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsRequest {
    private static final Logger log = LoggerFactory.getLogger(HttpsRequest.class);
    private static final int TIMEOUT_MIL_SECONDS = 30000;

    public static String doRequest(String url, String method, String data) throws DmeProviderException {
        return HttpsRequest.doRequest(url, method, data, 30000);
    }

    public static String doRequest(String url, String method, String data, int timeOutMilSeconds) throws DmeProviderException {
        String resp;
        OutputStream out = null;
        BufferedReader reader = null;
        HttpsURLConnection https = HttpsRequest.setHttps(url, method, timeOutMilSeconds);
        try {
            String str;
            https.connect();
            if (CommonUtils.isNotEmpty(data)) {
                out = https.getOutputStream();
                out.write(data.getBytes(StandardCharsets.UTF_8));
                out.close();
            }
            StringBuilder buffer = new StringBuilder();
            reader = new BufferedReader(new InputStreamReader(https.getInputStream(), StandardCharsets.UTF_8));
            while ((str = reader.readLine()) != null) {
                buffer.append(str);
            }
            resp = buffer.toString();
        }
        catch (IOException ex) {
            log.warn(ex.getMessage());
            throw new DmeProviderException(ex.getMessage());
        }
        catch (Exception exception) {
            log.warn("do request error.");
            throw new DmeProviderException(exception.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    log.warn(ex.getMessage());
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    log.warn(ex.getMessage());
                }
            }
        }
        return resp;
    }

    private static HttpsURLConnection setHttps(String url, String method, int timeOutMilSeconds) throws DmeProviderException {
        HttpsURLConnection https = null;
        try {
            SSLSocketFactory ssf = HttpsRequest.getSslSocketFactory();
            URL requestUrl = new URL(url);
            URLConnection connection = requestUrl.openConnection();
            if (connection instanceof HttpsURLConnection) {
                https = (HttpsURLConnection)connection;
                https.setRequestProperty("Content-Type", "application/json");
                https.setInstanceFollowRedirects(false);
                https.setSSLSocketFactory(ssf);
                https.setDoInput(true);
                https.setDoOutput(true);
                https.setConnectTimeout(timeOutMilSeconds);
                https.setReadTimeout(timeOutMilSeconds);
                https.setUseCaches(false);
                https.setRequestMethod(method);
            }
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException ex) {
            throw new DmeProviderException(ex.getMessage());
        }
        return https;
    }

    private static SSLSocketFactory getSslSocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
        HttpsURLConnection.setDefaultHostnameVerifier(new NullHostNameVerifier());
        TrustManager[] tm = new TrustManager[]{new MyX509TrustManager()};
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(null, tm, SecureRandom.getInstanceStrong());
        return sslContext.getSocketFactory();
    }

    private static class NullHostNameVerifier
    implements HostnameVerifier {
        private NullHostNameVerifier() {
        }

        @Override
        public boolean verify(String se, SSLSession sslSession) {
            return true;
        }
    }

    private static class MyX509TrustManager
    implements X509TrustManager {
        private MyX509TrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String se) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String se) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

