/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dmedata.deploytoolprovider.deploy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.huawei.dmedata.deploytoolprovider.common.CommonUtils;
import com.huawei.dmedata.deploytoolprovider.common.DmeProviderException;
import com.huawei.dmedata.deploytoolprovider.common.http.HttpsRequest;
import com.huawei.dmedata.deploytoolprovider.deploy.LoadDeployTool;
import com.huawei.dmedata.deploytoolprovider.deploy.StartProgram;
import com.huawei.dmedata.deploytoolprovider.model.ComboboxOption;
import com.huawei.dmedata.deploytoolprovider.model.DeployUpdateParam;
import com.huawei.dmedata.deploytoolprovider.model.FcUpdateParam;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigDeployParams {
    private static final Logger log = LoggerFactory.getLogger(ConfigDeployParams.class);
    private static final int RETRY_TIMES = 5;
    private static final int RETRY_TIMEOUT = 20;
    private static final int STEP_SLEEP_TIMEOUT = 10;

    private static int getProjectId() {
        try {
            String projectResponse = HttpsRequest.doRequest("https://127.0.0.1:8112/v1/hcb/projects", "GET", null);
            log.info("get project data:{}", (Object)projectResponse);
            JSONArray projects = Optional.ofNullable(projectResponse).map(JSON::parseObject).map(target -> target.getJSONObject("data")).map(target -> target.getJSONArray("projects")).orElse(new JSONArray());
            if (!projects.isEmpty()) {
                return projects.getJSONObject(projects.size() - 1).getInteger("project_id");
            }
        }
        catch (DmeProviderException ex) {
            log.error("get project id failed.{}", (Object)ex.getMessage());
        }
        return -1;
    }

    public static boolean checkHealth() {
        try {
            String projectResponse = HttpsRequest.doRequest("https://127.0.0.1:8112/v1/hcb/health", "GET", null);
            log.info("get check health data:{}", (Object)projectResponse);
            Integer statusCode = Optional.ofNullable(projectResponse).map(JSON::parseObject).map(target -> target.getInteger("status_code")).orElse(0);
            return statusCode.equals(200);
        }
        catch (DmeProviderException ex) {
            log.error("get check health failed.{}", (Object)ex.getMessage());
            return false;
        }
    }

    private static String updateInstallParams(int projectId, List<DeployUpdateParam> params) throws DmeProviderException {
        String urlInfo = MessageFormat.format("https://127.0.0.1:8112/v1/hcb/projects/{0}/params", projectId);
        try {
            String paramJson = JSON.toJSONString(params, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            String response = HttpsRequest.doRequest(urlInfo, "POST", paramJson);
            return Optional.ofNullable(response).map(JSON::parseObject).map(target -> target.getString("message")).orElse("");
        }
        catch (DmeProviderException ex) {
            log.error("update project params failed.{}", (Object)ex.getMessage());
            throw new DmeProviderException("update project params failed." + ex.getMessage());
        }
    }

    public static String updateFcParams(int projectId, List<FcUpdateParam> params) throws DmeProviderException {
        String urlInfo = MessageFormat.format("https://127.0.0.1:8112/v1/hcb/projects/{0}/params", projectId);
        try {
            String paramJson = JSON.toJSONString(params, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            String response = HttpsRequest.doRequest(urlInfo, "POST", paramJson);
            return Optional.ofNullable(response).map(JSON::parseObject).map(target -> target.getString("message")).orElse("");
        }
        catch (DmeProviderException ex) {
            log.error("update fc params failed.{}", (Object)ex.getMessage());
            throw new DmeProviderException("update fc params failed." + ex.getMessage());
        }
    }

    public static int getParamId(int projectId, String paramKey) throws DmeProviderException {
        String urlInfo = MessageFormat.format("https://127.0.0.1:8112/v1/hcb/projects/{0}/params", projectId);
        String response = HttpsRequest.doRequest(urlInfo, "GET", null);
        JSONObject json = JSONObject.parseObject((String)response);
        return json.getJSONArray("data").stream().filter(v -> ((JSONObject)v).getString("param_key").equals(paramKey)).map(v -> ((JSONObject)v).getIntValue("param_id")).findFirst().orElseThrow(() -> new DmeProviderException("get param_id by param_key failed."));
    }

    public static int initProject(String deployToolsPath) throws DmeProviderException {
        ConfigDeployParams.intiProject(deployToolsPath);
        int projectId = ConfigDeployParams.getProjectId();
        for (int retryTimes = 5; projectId == -1 && retryTimes > 0; --retryTimes) {
            try {
                TimeUnit.SECONDS.sleep(20L);
            }
            catch (InterruptedException ex) {
                log.warn("sleep exception:{}", (Object)ex.getMessage());
            }
            ConfigDeployParams.initParameters(deployToolsPath);
            projectId = ConfigDeployParams.getProjectId();
        }
        if (projectId == -1) {
            log.error("retry to get projectId {} times still failed.", (Object)5);
            throw new DmeProviderException("retry to get projectId still failed.");
        }
        log.info("get projectId success.projectId:{}", (Object)projectId);
        return projectId;
    }

    public static String setConfigParam(int projectId, List<DeployUpdateParam> updateParamList) throws DmeProviderException {
        if (updateParamList != null && updateParamList.size() > 0) {
            for (DeployUpdateParam param : updateParamList) {
                param.setParamKey(param.getParamKey().replace("DMEData_", ""));
                param.setProjectId(String.valueOf(projectId));
                param.setComponent("DMEData");
                param.setComponentType("BASE");
                if (!"combobox".equals(param.getControlType())) continue;
                ConfigDeployParams.setOptions(param);
            }
        }
        return ConfigDeployParams.updateInstallParams(projectId, updateParamList);
    }

    private static void setOptions(DeployUpdateParam scene) {
        String[] items = scene.getItems().split("\\|");
        String[] displayCns = CommonUtils.isEmpty(scene.getDisplayCn()) ? items : scene.getDisplayCn().split("\\|");
        ArrayList<ComboboxOption> optionList = new ArrayList<ComboboxOption>(items.length);
        for (int index = 0; index < items.length; ++index) {
            ComboboxOption option = new ComboboxOption();
            option.setKey(items[index]);
            option.setValue(items[index]);
            option.setLabel(displayCns[index]);
            optionList.add(option);
        }
        scene.setOptions(optionList);
    }

    private static void intiProject(String deployToolsPath) throws DmeProviderException {
        log.info("deployToolsPath:{}", (Object)deployToolsPath);
        LoadDeployTool.checkFile(deployToolsPath);
        LoadDeployTool.handleParameterJsonFile(deployToolsPath);
        CommonUtils.sleepSeconds(10L);
        StartProgram.startClmBat(deployToolsPath);
        CommonUtils.sleepSeconds(10L);
        ConfigDeployParams.checkHealthAndRetry(deployToolsPath);
        ConfigDeployParams.changeStatusOfIoSkip(deployToolsPath, "true");
        ConfigDeployParams.initParameters(deployToolsPath);
    }

    public static void changeStatusOfIoSkip(String deployToolsPath, String newStatus) throws DmeProviderException {
        String path = deployToolsPath + "\\hcb\\config.ini";
        try {
            String line;
            File file = new File(path);
            BufferedReader reader = new BufferedReader(new FileReader(file));
            StringBuilder content = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                content.append(line).append("\r");
            }
            reader.close();
            String newContent = content.toString().contains("skip_io_check") ? content.toString().replaceAll("skip_io_check=(true|false)", "skip_io_check=" + newStatus) : content.append("skip_io_check=" + newStatus).toString();
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write(newContent);
            writer.close();
        }
        catch (IOException e) {
            throw new DmeProviderException("Failed rewrite config.ini");
        }
    }

    private static void initParameters(String deployToolsPath) {
        StartProgram.startDME(deployToolsPath);
    }

    private static void checkHealthAndRetry(String deployToolsPath) {
        boolean healthStatusOK = ConfigDeployParams.checkHealth();
        for (int retryTimes = 5; !healthStatusOK && retryTimes > 0; --retryTimes) {
            try {
                TimeUnit.SECONDS.sleep(20L);
            }
            catch (InterruptedException ex) {
                log.warn("sleep exception:{}", (Object)ex.getMessage());
            }
            StartProgram.startClmBat(deployToolsPath);
            healthStatusOK = ConfigDeployParams.checkHealth();
        }
        if (!healthStatusOK) {
            log.warn("init clm.bat {} times still not running.", (Object)5);
        }
    }
}

