/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dmedata.deploytoolprovider.deploy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huawei.dmedata.deploytoolprovider.common.DmeProviderException;
import com.huawei.dmedata.deploytoolprovider.common.http.HttpsRequest;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployProjectAction {
    private static final Logger log = LoggerFactory.getLogger(DeployProjectAction.class);

    private static String resume(int projectId) throws DmeProviderException {
        return DeployProjectAction.operateProject(projectId, "resume");
    }

    public static String start(int projectId) throws DmeProviderException {
        return DeployProjectAction.operateProject(projectId, "start");
    }

    private static String rollback(int projectId) throws DmeProviderException {
        return DeployProjectAction.operateProject(projectId, "rollback");
    }

    public static String commit(int projectId) throws DmeProviderException {
        return DeployProjectAction.operateProject(projectId, "commit");
    }

    public static String stop(int projectId) throws DmeProviderException {
        return DeployProjectAction.operateProject(projectId, "stop");
    }

    private static String operateProject(int projectId, String action) throws DmeProviderException {
        String urlInfo = MessageFormat.format("https://127.0.0.1:8112/v1/hcb/projects/{0}/action", projectId);
        try {
            JSONObject params = new JSONObject().fluentPut("action", (Object)action);
            return HttpsRequest.doRequest(urlInfo, "POST", JSON.toJSONString((Object)params));
        }
        catch (DmeProviderException ex) {
            log.error("project action failed. action:{},message:{}", (Object)action, (Object)ex.getMessage());
            throw new DmeProviderException(MessageFormat.format("project action failed. {0}", ex.getMessage()));
        }
    }
}

