/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dmedata.deploytoolprovider.deploy;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.dmedata.deploytoolprovider.common.CommonUtils;
import com.huawei.dmedata.deploytoolprovider.common.DmeProviderException;
import com.huawei.dmedata.deploytoolprovider.constant.enums.ParameterFiledEnum;
import com.huawei.dmedata.deploytoolprovider.model.DeployUpdateParam;
import com.huawei.dmedata.deploytoolprovider.model.DmeLanguageCombination;
import com.huawei.dmedata.deploytoolprovider.model.DmeOptionItem;
import com.huawei.dmedata.deploytoolprovider.model.DmeParamTemplate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitParamTemplate {
    private static final Logger log = LoggerFactory.getLogger(InitParamTemplate.class);

    public static List<DmeParamTemplate> getParamTemplateBo(String deployFilePath) throws DmeProviderException {
        return InitParamTemplate.convertParamTemplateBo(InitParamTemplate.getParamTemplate(deployFilePath));
    }

    private static List<DmeParamTemplate> convertParamTemplateBo(List<DeployUpdateParam> paramsList) throws DmeProviderException {
        ArrayList<DmeParamTemplate> parameterTemplate = new ArrayList<DmeParamTemplate>();
        if (paramsList == null || paramsList.size() == 0) {
            return parameterTemplate;
        }
        JSONObject templateJson = CommonUtils.getTemplateFileJson("/template.json");
        String validate = templateJson.getString("validate");
        JSONObject namesReplacements = templateJson.getJSONObject("namesReplacement");
        JSONObject pwdMessages = templateJson.getJSONObject("messages");
        JSONArray keysReplacement = templateJson.getJSONArray("keysReplacement");
        for (DeployUpdateParam param : paramsList) {
            InitParamTemplate.handleKeysReplacement(param, keysReplacement);
            InitParamTemplate.handleNamesReplacement(param, namesReplacements);
            InitParamTemplate.handleParam(param, pwdMessages, validate);
            parameterTemplate.add(InitParamTemplate.createParamTemplateBo(param));
        }
        return parameterTemplate;
    }

    private static void handleKeysReplacement(DeployUpdateParam param, JSONArray keysReplacements) {
        if (keysReplacements == null || keysReplacements.size() == 0) {
            log.error("keysReplacement config param not exist.");
            return;
        }
        for (int index = 0; index < keysReplacements.size(); ++index) {
            String compareKey;
            String paramKey;
            JSONObject keysReplacement = keysReplacements.getJSONObject(index);
            if (param == null || CommonUtils.isEmpty(param.getParamKey()) || keysReplacement.keySet().size() == 0 || !(paramKey = param.getParamKey()).equals(compareKey = keysReplacement.keySet().toArray()[0].toString())) continue;
            param.setParamKey(keysReplacement.values().toArray()[0].toString());
        }
    }

    private static void handleNamesReplacement(DeployUpdateParam param, JSONObject namesReplacements) {
        if (namesReplacements == null || namesReplacements.size() == 0) {
            log.error("namesReplacement config param not exist.");
            return;
        }
        JSONObject namesReplacement = namesReplacements.getJSONObject(param.getParamKey());
        if (namesReplacement == null) {
            return;
        }
        log.info("replace title for {}.", (Object)param.getParamKey());
        param.setParamName(namesReplacement.getString("param_name"));
        param.setParamNameEn(namesReplacement.getString("param_name_en"));
        param.setDescriptionCn(namesReplacement.getString("description_cn"));
        param.setDescriptionEn(namesReplacement.getString("description_en"));
        param.setErrorMessageCn(namesReplacement.getString("error_msg_cn"));
        param.setErrorMessageEn(namesReplacement.getString("error_msg_en"));
    }

    private static void handleParam(DeployUpdateParam param, JSONObject pwdMessages, String validate) {
        if (pwdMessages == null || pwdMessages.size() == 0) {
            log.error("template config param not exist.");
            return;
        }
        JSONObject pwdMessage = pwdMessages.getJSONObject(param.getParamKey());
        if (pwdMessage == null) {
            return;
        }
        log.info("reset validate info for {}.", (Object)param.getParamKey());
        if (CommonUtils.isNotEmpty(validate)) {
            param.setValidate(validate);
        }
        param.setDescriptionEn(pwdMessage.getString("description_en"));
        param.setDescriptionCn(pwdMessage.getString("description_cn"));
        param.setErrorMessageEn(pwdMessage.getString("error_msg_en"));
        param.setErrorMessageCn(pwdMessage.getString("error_msg_cn"));
    }

    private static DmeParamTemplate createParamTemplateBo(DeployUpdateParam param) {
        DmeParamTemplate.DmeParamTemplateBuilder builder = DmeParamTemplate.builder();
        builder.id(param.getParamKey());
        builder.name(DmeLanguageCombination.builder().cn(param.getParamName()).en(param.getParamNameEn()).build());
        builder.description(DmeLanguageCombination.builder().cn(param.getDescriptionCn()).en(param.getDescriptionEn()).build());
        builder.defaultValue(param.getExample());
        builder.inputType(param.getControlType().toUpperCase(Locale.ROOT));
        builder.isRequired("required".equals(param.getRequired()));
        builder.validateRegex(InitParamTemplate.handleValidate(param.getValidate()));
        builder.validateMessage(DmeLanguageCombination.builder().cn(param.getErrorMessageCn()).en(param.getErrorMessageEn()).build());
        if ("combobox".equals(param.getControlType())) {
            String[] items = param.getItems().split("\\|");
            String[] displayCns = CommonUtils.isEmpty(param.getDisplayCn()) ? items : param.getDisplayCn().split("\\|");
            String[] displayEns = CommonUtils.isEmpty(param.getDisplayEn()) ? items : param.getDisplayEn().split("\\|");
            ArrayList<DmeOptionItem> optionItemBoList = new ArrayList<DmeOptionItem>(items.length);
            for (int index = 0; index < items.length; ++index) {
                DmeOptionItem.DmeOptionItemBuilder optionItemBuilder = DmeOptionItem.builder();
                optionItemBuilder.value(items[index]);
                optionItemBuilder.display(DmeLanguageCombination.builder().cn(displayCns[index]).en(displayEns[index]).build());
                optionItemBoList.add(optionItemBuilder.build());
            }
            builder.itemList(optionItemBoList);
        }
        builder.condition(param.getCondition());
        return builder.build();
    }

    private static String handleValidate(String originValidate) {
        if (CommonUtils.isEmpty(originValidate)) {
            return originValidate;
        }
        if (originValidate.startsWith("regex")) {
            String[] arrays = originValidate.split("\\|\\|");
            if (arrays.length <= 1) {
                return originValidate;
            }
            return arrays[1];
        }
        return originValidate;
    }

    public static List<DeployUpdateParam> getParamTemplate(String deployFilePath) throws DmeProviderException {
        String cfgFilePath = deployFilePath + "\\product-lld\\cfgs\\parameter-sys_deploy.cfg";
        File cfgFile = new File(cfgFilePath);
        ArrayList<String> fileContents = new ArrayList<String>();
        try (FileInputStream fileInputStream = new FileInputStream(cfgFile);
             BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8));){
            String str;
            while ((str = br.readLine()) != null) {
                if (!CommonUtils.isNotEmpty(str) || str.startsWith("#")) continue;
                fileContents.add(str);
            }
        }
        catch (IOException ex) {
            log.error("get cfg parameter failed.{}", (Object)ex.getMessage());
            throw new DmeProviderException(ex.getMessage());
        }
        return InitParamTemplate.getParamTemplateFromFileContent(fileContents);
    }

    private static List<DeployUpdateParam> getParamTemplateFromFileContent(List<String> fileContents) {
        ArrayList<DeployUpdateParam> parameterTemplate = new ArrayList<DeployUpdateParam>();
        if (fileContents == null || fileContents.size() == 0) {
            return parameterTemplate;
        }
        DeployUpdateParam param = null;
        int numberIndex = 1;
        String key = "";
        for (int index = 0; index < fileContents.size(); ++index) {
            String value;
            boolean isModelEndFlag;
            String lineText = fileContents.get(index);
            boolean bl = isModelEndFlag = lineText.startsWith("[") || index == fileContents.size() - 1;
            if (isModelEndFlag) {
                if (param != null) {
                    parameterTemplate.add(param);
                }
                param = new DeployUpdateParam();
                if (!CommonUtils.isNotEmpty(lineText) || !lineText.startsWith("[")) continue;
                param.setParamKey(lineText.substring(lineText.indexOf("[") + 1, lineText.indexOf("]")));
                param.setIndexId(String.valueOf(numberIndex));
                param.setParamId(String.valueOf(numberIndex++));
                continue;
            }
            int pos = lineText.indexOf("=");
            String left = lineText.substring(0, pos).trim();
            String right = "";
            if (!lineText.endsWith("=")) {
                right = lineText.substring(pos + 1).trim();
            }
            if (CommonUtils.isNotEmpty(right)) {
                key = left;
                value = right;
            } else {
                if (pos > 0) continue;
                value = lineText.trim();
            }
            InitParamTemplate.setParamFiledValue(param, key, value, CommonUtils.isEmpty(right));
        }
        return InitParamTemplate.AdjustParams(parameterTemplate);
    }

    private static void setParamFiledValue(DeployUpdateParam param, String key, String value, boolean isAppend) {
        ParameterFiledEnum filed = ParameterFiledEnum.getParameterFiledEnum(key);
        filed.setParameterFiledValue(param, key, value, isAppend);
    }

    private static List<DeployUpdateParam> AdjustParams(List<DeployUpdateParam> parameterTemplate) {
        parameterTemplate.removeIf(p -> p.getParamKey().contains("optional_components"));
        parameterTemplate.removeIf(p -> p.getParamKey().contains("open_high_level_key"));
        parameterTemplate.removeIf(p -> p.getParamKey().contains("unified_password"));
        parameterTemplate.stream().filter(p -> p.getParamKey().contains("auth_type")).forEach(p -> {
            p.setItems("NO|POE|IAM");
            p.setDisplayCn("\u5426|\u662f-POE\u9274\u6743|\u662f-IAM\u9274\u6743");
            p.setDisplayEn("No|Yes-POE Authentication|Yes-IAM Authentication");
        });
        return parameterTemplate;
    }
}

