/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dmedata.deploytoolprovider.deploy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.dmedata.deploytoolprovider.common.CommonUtils;
import com.huawei.dmedata.deploytoolprovider.common.DmeProviderException;
import com.huawei.dmedata.deploytoolprovider.common.http.HttpsRequest;
import com.huawei.dmedata.deploytoolprovider.constant.TaskStatusMap;
import com.huawei.dmedata.deploytoolprovider.constant.enums.InstallTaskStatusEnum;
import com.huawei.dmedata.deploytoolprovider.model.DmeLanguageCombination;
import com.huawei.dmedata.deploytoolprovider.model.DmeProgress;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallProgress {
    private static final Logger log = LoggerFactory.getLogger(InstallProgress.class);

    public static List<DmeProgress> getInstallProgress(int projectId) throws DmeProviderException {
        ArrayList<DmeProgress> tasksProgress = new ArrayList<DmeProgress>();
        JSONArray tasks = InstallProgress.getProjectTasks(projectId);
        for (int index = 0; index < tasks.size(); ++index) {
            JSONObject task = tasks.getJSONObject(index);
            String taskId = task.getString("taskid");
            String taskType = InstallProgress.taskTypeConvert(task.getString("type"));
            int thisEstimatetime = 0;
            if ("Precheck".equals(CommonUtils.capitalize(task.getString("name_en")))) {
                thisEstimatetime = 30;
            }
            if ("Installation".equals(CommonUtils.capitalize(task.getString("name_en")))) {
                thisEstimatetime = 90;
            }
            DmeProgress taskProgress = DmeProgress.builder().key(task.getString("id")).id(taskId).name(DmeLanguageCombination.builder().cn(task.getString("name_cn")).en(CommonUtils.capitalize(task.getString("name_en"))).build()).taskType(taskType).description(DmeLanguageCombination.builder().cn(task.getString("description_cn")).en(task.getString("description_en")).build()).endTime(InstallProgress.getTaskEndTIme(task.getString("status"), task.getString("updated_date"))).startTime(task.getString("start_time")).state(TaskStatusMap.taskStateConvert(task.getString("status"))).isMainTask(true).estimateTime(thisEstimatetime).build();
            tasksProgress.add(taskProgress);
            tasksProgress.addAll(InstallProgress.getSubTasksProgresses(projectId, taskId, taskType));
        }
        return tasksProgress;
    }

    private static String getTaskEndTIme(String status, String updateTime) {
        return InstallTaskStatusEnum.FINISHED.toString().equals(status) || InstallTaskStatusEnum.FAILED.toString().equals(status) || InstallTaskStatusEnum.SKIP.toString().equals(status) ? updateTime : "";
    }

    private static List<DmeProgress> getSubTasksProgresses(int projectId, String taskId, String taskType) throws DmeProviderException {
        ArrayList<DmeProgress> subTasksProgress = new ArrayList<DmeProgress>();
        JSONArray subTasks = InstallProgress.getProjectSubTasks(projectId, taskId);
        for (int pj = 0; pj < subTasks.size(); ++pj) {
            JSONObject subTask = subTasks.getJSONObject(pj);
            DmeProgress subTaskProgress = DmeProgress.builder().key(subTask.getString("id")).id(subTask.getString("subtaskid")).name(DmeLanguageCombination.builder().cn(subTask.getString("name_cn")).en(subTask.getString("name_en")).build()).taskType(taskType).description(DmeLanguageCombination.builder().cn(subTask.getString("description_cn")).en(subTask.getString("description_en")).build()).endTime(InstallProgress.getTaskEndTIme(subTask.getString("status"), subTask.getString("updated_date"))).startTime(subTask.getString("starttime")).state(TaskStatusMap.taskStateConvert(subTask.getString("status"))).isMainTask(false).parentTaskId(taskId).errorMessage(DmeLanguageCombination.builder().en(subTask.getString("error_msg_en")).cn(subTask.getString("error_msg_cn")).build()).suggestMessage(DmeLanguageCombination.builder().en(subTask.getString("suggestion_en")).cn(subTask.getString("suggestion_cn")).build()).estimateTime(InstallProgress.parseEstimateTime(subTask.getString("estimate_time"))).build();
            subTasksProgress.add(subTaskProgress);
        }
        return subTasksProgress;
    }

    private static int parseEstimateTime(String time) {
        try {
            return Integer.parseInt(InstallProgress.defaultString(time, "").replace("min", "").trim());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static String defaultString(String str, String defaultStr) {
        return str == null ? defaultStr : str;
    }

    private static String taskTypeConvert(String taskType) {
        if (CommonUtils.isEmpty(taskType)) {
            return "UNKNOWN";
        }
        return taskType.toLowerCase(Locale.ROOT).contains("check") ? "CHECK" : "INSTALL";
    }

    private static JSONArray getProjectTasks(int projectId) throws DmeProviderException {
        String urlInfo = MessageFormat.format("https://127.0.0.1:8112/v1/hcb/projects/{0}/tasks", projectId);
        try {
            String projectTasksResponse = HttpsRequest.doRequest(urlInfo, "GET", null);
            return Optional.ofNullable(projectTasksResponse).map(JSON::parseObject).map(target -> target.getJSONObject("data")).map(target -> target.getJSONArray("tasks")).orElse(new JSONArray());
        }
        catch (DmeProviderException ex) {
            log.error("get project tasks failed.{}", (Object)ex.getMessage());
            throw new DmeProviderException(MessageFormat.format("get project tasks failed. {0}", ex.getMessage()));
        }
    }

    private static JSONArray getProjectSubTasks(int projectId, String taskId) throws DmeProviderException {
        String urlInfo = MessageFormat.format("https://127.0.0.1:8112/v1/hcb/projects/{0}/tasks/{1}/subtasks", projectId, taskId);
        try {
            String projectTasksResponse = HttpsRequest.doRequest(urlInfo, "GET", null);
            return Optional.ofNullable(projectTasksResponse).map(JSON::parseObject).map(target -> target.getJSONObject("data")).map(target -> target.getJSONArray("tasks")).orElse(new JSONArray());
        }
        catch (DmeProviderException ex) {
            log.error("get project subtasks failed.{}", (Object)ex.getMessage());
            throw new DmeProviderException(MessageFormat.format("get project subtasks failed. {0}", ex.getMessage()));
        }
    }
}

