/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dmedata.deploytoolprovider.deploy;

import com.alibaba.fastjson.JSONObject;
import com.huawei.dmedata.deploytoolprovider.common.CmdOperation;
import com.huawei.dmedata.deploytoolprovider.common.CommonUtils;
import com.huawei.dmedata.deploytoolprovider.common.DmeProviderException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadDeployTool {
    private static final Logger log = LoggerFactory.getLogger(LoadDeployTool.class);

    public static void checkFile(String deployFilePath) throws DmeProviderException {
        String[] checkFiles;
        if (CommonUtils.isEmpty(deployFilePath)) {
            log.error("deployFilePath is empty.");
            throw new DmeProviderException("deployFilePath error.");
        }
        for (String checkFilePath : checkFiles = new String[]{deployFilePath, deployFilePath + "\\hcb\\common\\3rd\\Python39\\python.exe", deployFilePath + "\\hcb\\software\\clm\\webapp\\flaskr.py", deployFilePath + "\\hcb\\common\\pythonscript\\hcb_resource_init_v1.py"}) {
            File file = new File(checkFilePath);
            if (file.exists()) continue;
            log.error("file {} lost", (Object)checkFilePath);
            throw new DmeProviderException("deployFile file lost.");
        }
    }

    public static boolean handleParameterJsonFile(String deployFilePath) throws DmeProviderException {
        String fileName = deployFilePath + "\\hcb\\common\\pythonscript\\parameter.json";
        File file = new File(fileName);
        if (file.exists() && !file.delete()) {
            return false;
        }
        String initPassword = "";
        JSONObject parameterJson = LoadDeployTool.initParameterJsonContent(initPassword);
        try (BufferedWriter out = new BufferedWriter(new FileWriter(fileName));){
            out.write(parameterJson.toJSONString());
        }
        catch (IOException ex) {
            log.error("init parameter.json file failed.{}", (Object)ex.getMessage());
            throw new DmeProviderException("init parameter.json file failed.");
        }
        log.info("init parameter.json file finish.");
        return true;
    }

    private static JSONObject initParameterJsonContent(String initPassword) {
        return new JSONObject().fluentPut("DMEData_interface_startup", (Object)"YES").fluentPut("c_DMEData", (Object)1).fluentPut("d_sys_project_type", (Object)"deploy").fluentPut("DMEData_scene", (Object)"VM").fluentPut("DMEData_system_language", (Object)"zh_CN").fluentPut("DMEData_deploy_system", (Object)"EulerOS").fluentPut("DMEData_CPU_architecture", (Object)"X86").fluentPut("DMEData_open_sftpd", (Object)"YES").fluentPut("DMEData_deploy_node_number", (Object)1).fluentPut("DMEData_ip1", (Object)"192.168.0.1").fluentPut("DMEData_root_password1", (Object)initPassword).fluentPut("DMEData_lvs_ip", (Object)"192.168.0.3").fluentPut("DMEData_nic", (Object)"ens33").fluentPut("DMEData_deploy_password", (Object)initPassword).fluentPut("DMEData_om_password", (Object)initPassword).fluentPut("DMEData_sopuser_password", (Object)initPassword).fluentPut("DMEData_ossadm_password", (Object)initPassword).fluentPut("DMEData_ossuser_password", (Object)initPassword).fluentPut("DMEData_zenith_sys_password", (Object)initPassword).fluentPut("DMEData_redis_dbuser_password", (Object)initPassword).fluentPut("DMEData_rabbitmq_password", (Object)initPassword).fluentPut("DMEData_protect_pvalue_password", (Object)initPassword).fluentPut("DMEData_er_cert_password", (Object)initPassword).fluentPut("DMEData_es_password", (Object)initPassword).fluentPut("DMEData_sftpuser_password", (Object)initPassword).fluentPut("DMEData_db_default_value_password", (Object)initPassword).fluentPut("DMEData_package_path", (Object)"").fluentPut("DMEData_deploy_backup", (Object)"").fluentPut("DMEData_auth_type", (Object)"").fluentPut("DMEData_sdn_scene", (Object)"").fluentPut("DMEData_FC_basic_manage", (Object)"").fluentPut("DMEData_FC_basic_name", (Object)"").fluentPut("DMEData_FC_basic_ip", (Object)"").fluentPut("DMEData_FC_basic_user", (Object)"").fluentPut("DMEData_FC_basic_password", (Object)"").fluentPut("DMEData_FC_basic_port", (Object)"").fluentPut("DMEData_FC_basic_cert", (Object)"").fluentPut("DMEData_FC_snmp_protocol_version", (Object)"").fluentPut("DMEData_FC_snmp_security_user", (Object)"").fluentPut("DMEData_FC_snmp_auth_protocol", (Object)"").fluentPut("DMEData_FC_snmp_auth_password", (Object)"").fluentPut("DMEData_FC_snmp_data_protocol", (Object)"").fluentPut("DMEData_FC_snmp_data_password", (Object)"").fluentPut("DMEData_FC_basic_vnc", (Object)"");
    }

    public static void executeUninstallBat(String deployFilePath) throws DmeProviderException {
        block4: {
            String fileName = deployFilePath + "\\uninstall.bat";
            File file = new File(fileName);
            if (file.exists()) {
                log.info("start exec uninstall.");
                String resourceInitCmd = CommonUtils.getPathDriverLetter(fileName) + "&";
                resourceInitCmd = resourceInitCmd + "cd " + CommonUtils.quotationMarks(CommonUtils.getPathFolder(fileName)) + "&";
                resourceInitCmd = resourceInitCmd + CommonUtils.quotationMarks(fileName);
                try {
                    String errorMessage = CmdOperation.cuteCmd(resourceInitCmd, true);
                    if (CommonUtils.isNotEmpty(errorMessage)) {
                        log.error(errorMessage);
                        throw new DmeProviderException(errorMessage);
                    }
                    break block4;
                }
                catch (DmeProviderException ex) {
                    log.error("execute uninstall.bat file failed..{}", (Object)ex.getMessage());
                    throw new DmeProviderException("execute uninstall.bat file failed.");
                }
            }
            log.error("uninstall file not exist.path:{}", (Object)deployFilePath);
            throw new DmeProviderException("uninstall file not exist.");
        }
        log.info("end exec uninstall.");
    }
}

