/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dmedata.deploytoolprovider.deploy;

import com.huawei.dmedata.deploytoolprovider.common.CmdOperation;
import com.huawei.dmedata.deploytoolprovider.common.CommonUtils;
import com.huawei.dmedata.deploytoolprovider.common.DmeProviderException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartProgram {
    private static final Logger log = LoggerFactory.getLogger(StartProgram.class);
    private static ExecutorService POOL_EXECUTOR = Executors.newSingleThreadExecutor();

    public static void startDME(String deployFilePath) {
        log.info("start exec hcb_resource_init_v1.py");
        String pythonPath = deployFilePath + "\\hcb\\common\\3rd\\Python39\\python.exe";
        String resourceInitPath = deployFilePath + "\\hcb\\common\\pythonscript\\hcb_resource_init_v1.py";
        String resourceInitCmd = CommonUtils.getPathDriverLetter(resourceInitPath) + "&";
        resourceInitCmd = resourceInitCmd + "cd " + CommonUtils.quotationMarks(CommonUtils.getPathFolder(resourceInitPath)) + "&";
        resourceInitCmd = resourceInitCmd + CommonUtils.quotationMarks(pythonPath) + " " + CommonUtils.quotationMarks(resourceInitPath) + " parameter.json";
        try {
            String errorMessage = CmdOperation.cuteCmd(resourceInitCmd, true);
            if (CommonUtils.isNotEmpty(errorMessage)) {
                log.error(errorMessage);
                throw new DmeProviderException(errorMessage);
            }
            log.info("start hcb_resource_init_v1.py success.");
        }
        catch (DmeProviderException ex) {
            log.error("start hcb_resource_init_v1.py failed.{}", (Object)ex.getMessage());
        }
    }

    public static void startClmBat(String deployFilePath) {
        log.info("enter start clm.bat.");
        if (!POOL_EXECUTOR.isShutdown()) {
            POOL_EXECUTOR.shutdown();
        }
        POOL_EXECUTOR = Executors.newSingleThreadExecutor();
        POOL_EXECUTOR.execute(() -> {
            log.info("begin start clm.bat.");
            String filePath = deployFilePath + "\\hcb\\common\\bat\\clm_cmd.bat";
            StringBuilder clmBatCmd = new StringBuilder();
            clmBatCmd.append(CommonUtils.getPathDriverLetter(filePath));
            clmBatCmd.append("&");
            clmBatCmd.append("cd ").append(CommonUtils.quotationMarks(CommonUtils.getPathFolder(filePath)));
            clmBatCmd.append("&");
            clmBatCmd.append(CommonUtils.quotationMarks(filePath)).append(" start");
            try {
                String errorMessage = CmdOperation.cuteCmd(clmBatCmd.toString(), false);
                if (CommonUtils.isNotEmpty(errorMessage)) {
                    log.error(errorMessage);
                    throw new DmeProviderException(errorMessage);
                }
                log.info("start clm.bat success.");
            }
            catch (DmeProviderException ex) {
                log.error("start clm.bat failed.{}", (Object)ex.getMessage());
            }
            log.info("end start clm.bat.");
        });
        log.info("out exec clm.bat.");
    }
}

