/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dmedata.deploytoolprovider.deploy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huawei.dmedata.deploytoolprovider.common.CommonUtils;
import com.huawei.dmedata.deploytoolprovider.common.DmeProviderException;
import com.huawei.dmedata.deploytoolprovider.common.http.HttpsRequest;
import java.text.MessageFormat;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubTaskOperation {
    private static final Logger log = LoggerFactory.getLogger(SubTaskOperation.class);

    public static String retry(int projectId, String taskId, String subTaskId) throws DmeProviderException {
        return SubTaskOperation.subTaskOperation(projectId, taskId, subTaskId, "retry");
    }

    public static String skip(int projectId, String taskId, String subTaskId) throws DmeProviderException {
        return SubTaskOperation.subTaskOperation(projectId, taskId, subTaskId, "skip");
    }

    private static String subTaskOperation(int projectId, String taskId, String subTaskId, String action) throws DmeProviderException {
        if (CommonUtils.isEmpty(taskId) || CommonUtils.isEmpty(subTaskId)) {
            log.error("taskId or subTaskId is empty");
            throw new DmeProviderException("taskId and subTaskId should not be empty");
        }
        String urlInfo = MessageFormat.format("https://127.0.0.1:8112/v1/hcb/projects/{0}/tasks/{1}/subtasks/{2}/action", projectId, taskId, subTaskId);
        try {
            String paramJson = new JSONObject().fluentPut("action", (Object)action).toJSONString();
            String response = HttpsRequest.doRequest(urlInfo, "POST", paramJson);
            return Optional.ofNullable(response).map(JSON::parseObject).map(target -> target.getString("message")).orElse("");
        }
        catch (DmeProviderException ex) {
            log.error("subtask operation failed.action:{},message:{}", (Object)action, (Object)ex.getMessage());
            throw new DmeProviderException(MessageFormat.format("subtask operation failed.action:{0},message:{1}", action, ex.getMessage()));
        }
    }
}

