/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.feel.impl.juel.el;

import camundafeel.de.odysseus.el.misc.TypeConverterImpl;
import camundafeel.javax.el.ELException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.camunda.bpm.dmn.feel.impl.juel.FeelEngineLogger;
import org.camunda.bpm.dmn.feel.impl.juel.FeelLogger;

public class FeelTypeConverter
extends TypeConverterImpl {
    public static final FeelEngineLogger LOG = FeelLogger.ENGINE_LOGGER;

    @Override
    protected Boolean coerceToBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw LOG.unableToConvertValue(value, Boolean.class);
    }

    @Override
    protected BigDecimal coerceToBigDecimal(Object value) {
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        if (value instanceof Number) {
            return new BigDecimal(((Number)value).doubleValue());
        }
        throw LOG.unableToConvertValue(value, BigDecimal.class);
    }

    @Override
    protected BigInteger coerceToBigInteger(Object value) {
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toBigInteger();
        }
        if (value instanceof Number) {
            return BigInteger.valueOf(((Number)value).longValue());
        }
        throw LOG.unableToConvertValue(value, BigInteger.class);
    }

    @Override
    protected Double coerceToDouble(Object value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        throw LOG.unableToConvertValue(value, Double.class);
    }

    @Override
    protected Long coerceToLong(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number && this.isLong((Number)value)) {
            return ((Number)value).longValue();
        }
        throw LOG.unableToConvertValue(value, Long.class);
    }

    @Override
    protected String coerceToString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        throw LOG.unableToConvertValue(value, String.class);
    }

    @Override
    public <T> T convert(Object value, Class<T> type) throws ELException {
        try {
            return super.convert(value, type);
        }
        catch (ELException e) {
            throw LOG.unableToConvertValue(value, type, e);
        }
    }

    protected boolean isLong(Number value) {
        double doubleValue = value.doubleValue();
        return doubleValue == (double)((long)doubleValue);
    }
}

