text
cdrom
lang en_US.UTF-8
keyboard us
firewall --disabled
selinux --disabled
timezone Asia/Shanghai --utc
timesource --ntp-disable
bootloader --password={grubPassword} --location=mbr --append="net.ifnames=0 spectre_v2=off nopti noibrs noibpb"
rootpw --plaintext {password}
skipx
zerombr

clearpart --all --initlabel --list={diskList}
ignoredisk --only-use={diskList}
network --bootproto=static --ip={ip} --netmask={netmask} --gateway={gateway} --device={device}
%include /tmp/part-include
%pre --log=/root/pre.log
#!/usr/bin/bash
mkdir -p /opt/log
vgremove -f euleros oss_vg
disk_size_list=$(fdisk -l | grep Disk |grep -v mapper |grep -v loop |grep bytes | awk -F ' |:' '{{print $2 " " $6}}' | awk 'BEGIN{} {if ($2 >= 54760833024) {print}}' | sort -k2n)
disks=$(fdisk -l | grep Disk |grep -v mapper |grep -v loop |grep bytes | awk -F ' |:' '{{print $2}}')
disk_num=$(echo ${disks} | awk -F " " '{print NF}')
sys_disk=$(echo $disk_size_list | awk 'NR==1 {print $1}')
sys_disk_size=$(echo $disk_size_list | awk 'NR==1 {print $2}')
total_size=$(fdisk -l | grep Disk |grep -v mapper |grep -v loop |grep bytes | awk -F ' |:' '{{print $6}}' | awk -v total=0 '{total+=$1}END{printf "%.0f\t",total}')
data_disk_size=`expr ${total_size} - 53687091200`
# Disk partitioning information
echo "#start parted" > /tmp/part-include
if [ $sys_disk_size -ge 2199023255552 ]; then
  echo "part biosboot --fstype=biosboot --size=1 --ondisk=$sys_disk" >> /tmp/part-include
  data_disk_size=`expr ${total_size} - 53688139776`
fi

echo "part /boot --fstype=ext4 --ondisk=$sys_disk --size=1024" >> /tmp/part-include
echo "part pv.01 --ondisk=$sys_disk --size=50176" >> /tmp/part-include
echo "volgroup euleros pv.01" >> /tmp/part-include
echo "logvol / --fstype=ext4 --vgname=euleros --name=root --size=9216" >> /tmp/part-include
echo "logvol /var/log --fstype=ext4 --vgname=euleros --name=varlog --size=10240" >> /tmp/part-include
echo "logvol /tmp --fstype=ext4 --vgname=euleros --name=tmp --size=10240" >> /tmp/part-include
echo "logvol /home --fstype=ext4 --vgname=euleros --name=home --size=1 --grow" >> /tmp/part-include

if [ ${data_disk_size} -gt 54760833024 ]; then
pvs=""
for disk in ${disks[*]}
do
  if [ ${disk_num} -eq 1 ] || [ ${disk} != ${sys_disk} ]
  then
      pv_name=$(echo "pv.`echo ${disk} | awk -F '/' '{print $3}'`")
      echo "part ${pv_name} --size 1 --grow --ondisk=$disk" >> /tmp/part-include
      pvs="${pvs} ${pv_name}"
  fi
done
echo "volgroup oss_vg ${pvs}" >> /tmp/part-include
echo "logvol /opt/log --fstype=ext4 --vgname=oss_vg --name=optlog_vol --size=51200" >> /tmp/part-include
echo "logvol /opt --fstype=ext4 --vgname=oss_vg --name=opt_vol --size=1 --grow" >> /tmp/part-include
fi
%end

services --disabled="ntpd,firewalld" --enabled="sshd,chronyd"

%packages --ignoremissing --excludedocs
@^product
@core
%end

%post --log=/root/post.log
# Add xen and virtio drivers and rebuild initramfs
# return dracut for the installed kernel (not the running kernel):
cat > /etc/dracut.conf.d/virtdriver.conf << _EOF_
add_drivers+="xen-blkfront xen-netfront virtio_blk virtio_scsi virtio_net virtio_pci virtio_ring virtio"
_EOF_

KERNEL_VERSION=$(rpm -q kernel --qf '%{version}-%{release}.%{arch}\n')
dracut -f /boot/initramfs-${KERNEL_VERSION}.img ${KERNEL_VERSION}

# Since we disable consistent network naming, we need to make sure the eth0
# configuration file is in place so it will come up.
# Delete other network configuration first because RHEL/C7 networking will not
# restart successfully if there are configuration files for devices that do not
# exist.

sed -i '/^PermitRootLogin/d' /etc/ssh/sshd_config
sed -i '/^PasswordAuthentication/d' /etc/ssh/sshd_config
sed -i '/^UseDNS/d' /etc/ssh/sshd_config
echo "PermitRootLogin yes" >>/etc/ssh/sshd_config
echo "PasswordAuthentication yes" >>/etc/ssh/sshd_config
echo "UseDNS no" >>/etc/ssh/sshd_config

# default configuration of euler_security tool will disable root login, delete it
sed -i '/PermitRootLogin/d' /etc/euleros_security/security.conf

# ipv6 disabled
sed -i '/ipv6/d' /etc/euleros_security/security.conf
sed -i '/ipv6/d' /etc/sysctl.conf
sed -i 's/net.ifnames/ipv6.disable=1 &/' /etc/default/grub
sed -i 's/net.ifnames=0 //g' /etc/default/grub

# enable-verbose-boot
sed -i 's/rhgb\|quiet//g' /etc/default/grub
grub2-mkconfig -o /boot/grub2/grub.cfg

# ipv4.ip_forward=1
sed -i s/ipv4.ip_forward=@0/ipv4.ip_forward=@1/g /etc/euleros_security/security.conf
sed -i "s/ipv4.ip_forward=0/ipv4.ip_forward=1/g" /etc/rc.d/init.d/network
sysctl -q -p /etc/sysctl.conf

chmod 640 /root/post.log
cd /tmp/rpm
find /tmp/rpm -name "*.sh" | xargs dos2unix
cp scripts/config_network.sh scripts/parting_data_disk.sh /root
sed -i s/dme_storage_part/dme_data_part/g /root/parting_data_disk.sh
bash rpm_enter.sh

sed -i s/ONBOOT=.*/ONBOOT=yes/g /etc/sysconfig/network-scripts/ifcfg-e*
sed -i s/BOOTPROTO=.*/BOOTPROTO=static/g /etc/sysconfig/network-scripts/ifcfg-e*
rm -rf /etc/udev/rules.d/70-persistent-net.rules
rm -rf /etc/udev/rules.d/50-persistent-net.rules
rm -rf /root/.ssh/*
rm -rf /var/lib/dhclient/*
rm -rf /var/lib/yum/*
rm -rf /var/lib/docker/network/files/local-kv.db
rm -rf /var/lib/NetworkManager/*
rm -rf /var/cache/ldconfig/aux-cache
rm -rf /etc/docker/key.json
rm -rf /boot/initramfs-*kdump.img
rm -rf /var/log/wtmp
rm -rf /var/log/tuned/*.log
rm -rf /var/log/sysmonitor.log
rm -rf /var/log/journal/*
rm -rf /var/log/audit/*
rm -rf /opt/sut
rm -rf /etc/localtime_tmp
rm -rf /tmp/*

mkdir -p /var/log/crash
chmod 750 /var/log/crash
mkdir -p /usr/bin/rpm
chmod 700 /usr/bin/rpm
%end

reboot --eject
