//
//  SSLVPN.h
//  SecoSDK
//
//  Created by SDK on 2019/7/19.
//  Copyright © 2019年 Huawei. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN
typedef enum : NSUInteger {
    RELIABLE_TUNNEL_MODE,//可靠模式
    FAST_TUNNEL_MODE,//快速模式
    ADAPTIVE_TUNNEL_MODE,//自适应模式
} TUNNEL_MODE;

typedef enum : NSUInteger {
    SAVE_CONNECT_SUCCEED,//保存成功
    SAVE_CONNECT_FAILED,//保存失败
    SAVE_CONNECT_FAILED_REPEAT,//配置名称重复
    SAVE_CONNECT_FAILED_INVALID,//配置不全或格式有误
    SAVE_CONNECT_FAILED_USER_REFUSE,//首次保存配置到系统vpn配置时，需要用户同意并输入终端锁屏密码
    
} VPN_TUNNEL_CONNECT_ERROR;

typedef enum : NSUInteger {
    VPN_TUNNEL_CONNECTING,//正在连接
    VPN_WAITE_FOR_RESULT,//等待结果
    VPN_TUNNEL_FIRSTCONN_FAIL, //无法建立VPN连接，VPN服务器可能无法到达
    VPN_TUNNEL_CONNECT_LOGIN_OHERTYPE,//其他认证方式，暂不支持
    VPN_TUNNEL_CONNECT_SUCCEED, //vpn隧道建立成功
    LOGIN_CNEM_START_SUCCEED,//登陆成功，网络扩展启动成功
    LOGIN_CNEM_START_FAIL,//登陆成功，但网络扩展启动失败
    LOGIN_AUTH_FAIL,//认证失败
    LOGIN_USEROVERTOP_ERROR,//用户连接数已达到上限
    LOGIN_USER_FIRST_LOGIN_ERROR,//您的密码为初始状态，请修改密码后再开始业务
    LOGIN_USEREXPIREWEAK_ERROR,//您的密码已经过期，请和管理员联系
    VPN_CONNECTING_SUCCESS //连接成功
    
} VPN_CONNECTING_ERROR;

typedef enum : NSUInteger {
   VPN_RECONNECT_FAIL,//重连失败
   VPN_KICKOUT_SUCCESS,//被网关踢下线
   VPN_DHCP_ERROR //DHCP错误
} VPN_CONNECTED_RESULT_CODE;

typedef enum : NSUInteger {
    MODIFYPWD_SUCCESS,//修改成功
    MODIFYPWD_FORMAT_ERROR,//密码格式错误
    MODIFYPWD_FAIL_BECAUSE_SAVING //网关侧正在save,修改密码失败
} VPN_MODIFYPASSWORD_RESULT_CODE;
@protocol VPNStatusDelegate <NSObject>

//VPN未连接
- (void)whenTheVPNStatusDisconnected;
//VPN正在断开连接
- (void)whenTheVPNStatusDisconnecting;
//VPN已连接，并且随时接收网关返回的信息
- (void)whenTheVPNStatusConnectedWithConnectedErrorCode:(VPN_CONNECTED_RESULT_CODE)connectedErrorCode;
//VPN正在连接，并随时返回连接状态
- (void)whenTheVPNStatusConnectingWithConnectErrorCode:(VPN_CONNECTING_ERROR)connectErrorCode;

@end
@interface SSLVPN : NSObject

@property(nonatomic,weak)id<VPNStatusDelegate>delegate;
//0920-1
/**
 
 获取管理类单例对象
 
 @return 管理类单例对象
 */
+ (SSLVPN *)shareInstance;
/**
 
 初始化SSLVPN
 
 @param bundleIdetify 创建PacketTunnel的bundleIdetify
 */
- (void)SSLVPNInitWithPacketTunnelBundleIdetify:(NSString *)bundleIdetify;

/**
 
 创建SSLVPN连接
 
 @param connectName 连接名称
 @param serverAddress 连接网关地址
 @param serverPort 连接网关端口号
 @param isGMSSL 是否使用国密加密算法
 @param transferMode 传输模式
 @param username 用户名
 @param password 密码
 @param connectResult 连接结果回调
 */
- (void)connectVPNWithConnectName:(NSString *)connectName serverAddress:(NSString *)serverAddress serverPort:(NSString *)serverPort isGMSSL:(BOOL)isGMSSL transferMode:(TUNNEL_MODE)transferMode username:(NSString *)username password:(NSString *)password connectResult:(nullable void (^)(VPN_TUNNEL_CONNECT_ERROR))connectResult;
/**
 
 关闭VPN连接
 
 */
- (void)disconnectVPN;
/**
 
 收集日志
 
 */
- (void)collectLog;
/**
 
 修改密码
 
 @param oldPassword 旧密码
 @param newPassword 新密码
 @param completionHandler 修改密码结果回调
 
 */
- (void)modifyPasswordWithOldPassword:(NSString *)oldPassword AndNewPassword:(NSString *)newPassword CompletionHandler:(nullable void (^)(VPN_MODIFYPASSWORD_RESULT_CODE errorCode))completionHandler;
@end

NS_ASSUME_NONNULL_END
