//
//  WriteLog.h
//  SecoClientVPN
//
//  Created by xz on 2017/7/21.
//  Copyright © 2017年 work. All rights reserved.
//

#import <Foundation/Foundation.h>

#define SECOCLIENT_ERR_LOG      1      /* 程序无法正常完成操作，比如网络异常断开、数据收发异常、内存申请失败、入参检查错误等 */
#define SECOCLIENT_WARN_LOG     2      /* 进入一个异常分支，但并不会引起程序错误 */
#define SECOCLIENT_NOTICE_LOG   3      /* 日常运行提示信息，比如登录、退出日志 */
#define SECOCLIENT_DEBUG_LOG    4      /* 调试信息，打印比较频繁，打印内容多，例如报文内容打印、函数入口出口日志等 */

#define SECOCLIENT_DEV_LOG_FILE_NAME       "SecoClient_SecoClientUI.log"
#define SECOCLIENT_VPNEXTENTION_DEV_LOG_FILE_NAME       "SecoClient_SecoClientCS.log"
#define SECOCLIENT_USER_LOG_FILE_NAME    "user_log.txt"

#define LOG_TYPE_UI 0
#define LOG_TYPE_VPN 1

#define LOGWSERR(format,...)     [WriteLog write:@"WORKSPACE" level:SECOCLIENT_ERR_LOG func:__FUNCTION__ lineNum:__LINE__ logStr:format,##__VA_ARGS__]
#define LOGWSWARN(format,...)    [WriteLog write:@"WORKSPACE" level:SECOCLIENT_WARN_LOG func:__FUNCTION__ lineNum:__LINE__ logStr:format,##__VA_ARGS__]
#define LOGWSNOTICE(format,...)  [WriteLog write:@"WORKSPACE" level:SECOCLIENT_NOTICE_LOG func:__FUNCTION__ lineNum:__LINE__ logStr:format,##__VA_ARGS__]
#define LOGWSDEBUG(format,...)   [WriteLog write:@"WORKSPACE" level:SECOCLIENT_DEBUG_LOG func:__FUNCTION__ lineNum:__LINE__ logStr:format,##__VA_ARGS__]

@interface WriteLog : NSObject
+(void)write:(NSString*)Title level:(int)level func:(const char*)func lineNum:(int)lineNum logStr:(NSString*)format,...;
+(void)setLogLevel:(int)logLevel;

@end
