#!/bin/bash
###########################################################################
#
# Description:  Patch Install Tool for Campus R21
# Version：        V1.0
# Author:       w00284198
#
###########################################################################

# Get current path
curr_path="/opt/oss/spc121_upgrade_patch"
# find  backup_dir
backup_dir="$curr_path/backup"

timestamp=`date "+%Y%m%d%H%M%S"`
echo $timestamp > $curr_path/timestamp.txt

update_success="$curr_path/updateSuccess.txt"

# micro service root path
micro_service_path="/opt/oss/NCECAMPUS/apps"

new_version="V300R021C00SPC121"
old_version="V300R021C00SPC120"

new_time="20221025"
old_time="20220826"



#==========================================================================
#   Name:           log
#   Description:    log to console and file
#   Input: String message
#   Return:
#==========================================================================
function log()
{
    timestamp=`date "+%Y-%m-%d %H:%M:%S"`
    message="$timestamp $@"
    echo -e $message >> $curr_path/patch_upgrade.log
}

#==========================================================================
#   Name:           rollback
#   Description:    rollback jar
#   Input:          $1 jar name  $2 micro service name
#   Return:
#==========================================================================
function rollback()
{   
    if [ -d "${micro_service_path}/$2" ];then #判断节点有服务再替换打补丁
        log "[INFO]Begin to rollback $1."
        
        sudo -u ossuser chmod 770 ${micro_service_path}/$2/lib/$1
        sudo -u ossuser cp ${backup_dir}/$1 ${micro_service_path}/$2/lib/
        
        if [ "$1" = "license-branch-service-21.0120.0560.0200-SNAPSHOT.jar" ]; then
            sudo -u ossuser chmod 550 ${micro_service_path}/$2/lib/$1
        else
            sudo -u ossuser chmod 400 ${micro_service_path}/$2/lib/$1
        fi
        
        log "[INFO]Rollback $1 successfully."
        echo "[INFO]Rollback $1 successfully."
    fi
}

function rollback_PONMgmtService()
{
    #DTS2022092716071    
    original_path="/opt/oss/NCECAMPUS/apps/PONMgmtService/webapps/ROOT/WEB-INF/classes/com/huawei/u2020/ponmgmtservice/business/campus"

    if [ -d "/opt/oss/NCECAMPUS/apps/PONMgmtService" ];then
        if [ -d "$backup_dir/reconciliation" ];then #如果之前备份过,则回退
            #将备份文件改为可读可写可执行权限
            sudo -u ossuser chmod 770 -R $backup_dir/reconciliation
            #改权限
            sudo -u ossuser chmod 770 -R $original_path/reconciliation
            
            sudo -u ossuser cp -r ${backup_dir}/reconciliation $original_path
            
            #恢复权限
            sudo -u ossuser chmod 440 -R $original_path/reconciliation
            sudo -u ossuser chmod 550 $original_path/reconciliation
            
            log "[INFO]Rollback PONMgmtService successfully."
            echo "[INFO]Rollback PONMgmtService successfully."
        else
            log "[ERROR]Rollback PONMgmtService failed, because backup PONMgmtService failed."
        fi
    else
        log "[INFO]No need to rollback PONMgmtService, because has no PONMgmtService."
    fi
}

function rollback_ap_IotConfig()
{
    #DTS2022092807292    
    original_path="/opt/oss/envs/Product-NginxService/21.0120.0300.0001/etc/nginx/html/webroot/deviceConfig-app/themes/default/eview_modules/ap_config"

    if [ -d "/opt/oss/envs/Product-NginxService" ];then
        if [ -d "$backup_dir/ap_IotConfig" ];then #如果之前备份过,则回退
            #不改权限可替换成功
            sudo -u ossuser cp -r ${backup_dir}/ap_IotConfig $original_path
            log "[INFO]Rollback ap_IotConfig successfully."
            echo "[INFO]Rollback ap_IotConfig successfully."
        else
            log "[ERROR]Rollback ap_IotConfig failed, because backup ap_IotConfig failed."
        fi
    else
        log "[INFO]No need to rollback ap_IotConfig, because has no NginxService."
    fi
}


function rollback_RadiusServerService_configuration()
{
    #DTS2022090913948    
    original_path="/opt/oss/NCECAMPUS/apps/RadiusServerService/controller/configuration"

    if [ -d "/opt/oss/NCECAMPUS/apps/RadiusServerService" ];then
        # 修改dbconfig
        filename=access_authen_common_dbm.xml
        if [ -f "$backup_dir/$filename" ];then #如果之前备份过,则回退
            #不改权限可替换成功
            sudo -u ossuser cp -r ${backup_dir}/$filename $original_path/dbconfig
            log "[INFO]Rollback $filename successfully."
            echo "[INFO]Rollback $filename successfully."
        else
            log "[ERROR]Rollback $filename failed, because backup $filename failed."
        fi
        
        # 修改dbconfig
        filename=ac_campus_radiusauth_radiusserver_service-cfg.xml
        if [ -f "$backup_dir/$filename" ];then #如果之前备份过,则回退
            #不改权限可替换成功
            sudo -u ossuser cp -r ${backup_dir}/$filename $original_path/threadpools
            log "[INFO]Rollback $filename successfully."
            echo "[INFO]Rollback $filename successfully."
        else
            log "[ERROR]Rollback $filename failed, because backup $filename failed."
        fi
        
    else
        log "[INFO]No need to rollback $filename, because has no RadiusServerService."
    fi
}

#==========================================================================
#   Name:           rollback_version
#   Description:    rollback version
#   Input: 
#   Return:
#==========================================================================
function rollback_version()
{
    updated=0
    if [ -d "$1" ];then
        for file in `find $1/manager/DeployAgent/svcs-pub/NCECAMPUS-Product-CampusBaseService-campusbaseservice/CampusSolutionService-*  -name "productioninfo.properties"`
        do
            file_name=`basename $file`
            if [[ "$file_name" == "productioninfo.properties" ]]; then
                sed -i "s/product.info.version=.*/product.info.version=$old_version/g" $file
                sed -i "s/product.info.date=.*/product.info.date=$old_time/g" $file
                if [ $? -eq 0 ]; then
                    updated=1
                else
                    log "Rollback $1/$file_name failed"
                    echo "Rollback $1/$file_name failed"
                fi
            fi
        done
        if [[ $updated -eq 1 ]]; then
            log "[INFO]Rollback version successfully."
            echo "[INFO]Rollback version successfully."
        fi
    fi
    
    #回滚成功后删除升级标志
    rm -f $update_success
}

#==========================================================================
#   Name:           restart_service
#   Description:    restart the service which need restart
#   Input: 
#   Return:
#==========================================================================
function restart_service()
{
    if [ -d "${micro_service_path}/$1" ];then #判断节点有服务再替换打补丁
        bash /opt/oss/manager/agent/bin/ipmc_adm -cmd restartapp -app $1
        log "[INFO]Restarted $1."
    else
        log "[INFO]No rollback was required $1."
    fi
}


#==========================================================================
#   Name:           restart_services
#   Description:    restart the services which need restart
#   Input: 
#   Return:
#==========================================================================
function restart_services()
{

    #涉及的服务统一在这里填写，用空格分隔，重启服务会调用
    service_list=(CampusCfgService CampusFabricService RadiusServerService CampusAccountService CampusBaseService PONMgmtService)
    
    log "Restart service begin."
    for service in ${service_list[@]}
    do
        restart_service ${service}
    done
}


#==========================================================================
#   Name:           Entrance
#   Description:    Main Function
#   Input: 
#   Return:
#==========================================================================
function main()
{   
    log "-------- Rollback begin for note--------"

    # $1 :jar名 
    # $2 :服务名

    #DTS2022091414712
    rollback "fabric-util-21.0120.0300.0001.jar" "CampusFabricService"
    rollback "virtual-network-service-21.0120.0300.0001.jar" "CampusFabricService"
    rollback "virtual-network-ui-21.0120.0300.0001.jar" "CampusFabricService"
    
    #DTS2022092218076
    rollback "fabric-manager-service-21.0120.0300.0001.jar" "CampusFabricService"
    rollback "security-access-service-21.0120.0300.0001.jar" "CampusFabricService"
    
    #DTS2022090712470
    rollback "net-fabric-service-21.0120.0300.0001.jar" "CampusFabricService"

    #DTS2022092402258 DTS2022090911018 DTS2022092805441 DTS2022093001030
    rollback "radius-authentication-service-21.0120.0300.0001.jar" "RadiusServerService"
    
    #DTS2022092402258 DTS2022090913948
    rollback "radius-baseservices-21.0120.0300.0001.jar" "RadiusServerService"
    
    #DTS2022090913948 DTS2022091314312
    rollback "accesscommon-cbb-utils-21.0120.0300.0001.jar" "RadiusServerService"
    rollback "account-res-21.0120.0300.0001.jar" "RadiusServerService"
    rollback_RadiusServerService_configuration
    
    #DTS2022092409171
    rollback "ldap-mgr-module-21.0120.0300.0001.jar" "CampusAccountService"
    
    #DTS2022092409257
    rollback "accountservice-iaereconciliation-module-21.0120.0300.0001.jar" "CampusAccountService"
    #DTS2022092201372
    rollback "license-branch-service-21.0120.0560.0200-SNAPSHOT.jar" "CampusBaseService"
    
    #DTS2022092807292 
    rollback "netcfg-device-adapter-pkg-service-21.0120.0300.0001.jar" "CampusCfgService"
    rollback_ap_IotConfig
    
    #DTS2022092716071
    rollback_PONMgmtService
    
    #更新版本R20
    rollback_version "/opt/oss/share"
    #更新版本R18或R19升级场景
    rollback_version "/var/share/oss"    
    restart_services
    
    log "-------- Rollback end for note--------"
}


main "$@"