#!/bin/bash
###########################################################################
#
# Description:  Patch Install Tool for Campus R21
# Version：        V1.0
# Author:       cwx598742
#
###########################################################################

#set -x

# Get node_ip_list
node_ip_list=`grep maintenance /opt/oss/manager/etc/sysconf/nodelists.json -C3 | grep IP | cut -d\" -f4`
echo $node_ip_list

SSHMGRPATH="/opt/oss/manager/tools/common/sshmgr" 

#==========================================================================
#   Name:           log
#   Description:    log to console and file
#   Input: String message
#   Return:
#==========================================================================
function log()
{
    timestamp=`date "+%Y-%m-%d %H:%M:%S"`
    message="$timestamp $@"
    echo -e $message >> ./patch_upgrade.log
}


#==========================================================================
#   Name:           Entrance
#   Description:    Main Function
#   Input: 
#   Return:
#==========================================================================
function main()
{
    log "-------- Rollback begin --------"
    index=0
    chown -R ossadm:ossgroup /opt/Campus_SPC121_upgrade_patch
    for node_ip in ${node_ip_list[*]}
    do
       
        echo "[INFO]Begin rollback for $node_ip, waitting..."
        
        su - ossadm -c ". /opt/oss/manager/agent/bin/engr_profile.sh; sh $SSHMGRPATH/sshmgr.sh -exectype cmd -ip ${node_ip} -cmd \"sh /opt/oss/spc121_upgrade_patch/singleNoteRollback.sh\""
            
        if [ $? -ne 0 ];then
            echo "[ERROR]Rollback Campus failed for $node_ip"
            exit 1
        else 
            echo "Rollback Campus successfully for $node_ip"
        fi
            
    done
    
    echo "waiting 5 minutes to restart..."
    log "waiting 5 minutes to restart..."
    sleep 300
    log "Rollback spc121 successfully"    
    log "-------- Rollback end --------"
    echo "Rollback spc121 successfully"    
}

main "$@"


