#!/bin/bash
CUR_PATH=$(dirname $(readlink -f $0))

read input_pwd
if [ "${input_pwd}X" == "X" ];then
    exit 1
fi
input_pwd=($input_pwd)
ftppwd=${input_pwd[0]}

. /opt/oss/manager/agent/bin/engr_profile.sh

SSHMGRPATH="/opt/oss/manager/tools/common/sshmgr"

function set_ftp()
{
    if [ "${ftppwd}X" != "X" ];then
        ftppwd=`$PYTHONHOME/bin/python <<EOF
from util import ossext
en=ossext.Cipher.encrypt("$ftppwd")
print(en)
EOF`
        ftpip=`cat /opt/oss/manager/var/agent/managerip.conf|grep localip|cut -d= -f 2`
        echo "{
        \"backupmode\": \"SFTP\",
        \"SFTPList\": [
            {
            \"SFTPServerIPAddress\": \"${ftpip}\",
            \"username\": \"ftpuser\",
            \"password\": \"${ftppwd}\",
            \"backuppath\": \"backup\"
            }
        ]
        }" > $CUR_PATH/backuprestore.json
        # 设置本机未默认备份服务器
        bash /opt/oss/manager/tools/backuprestore/setglobalpara.sh -input $CUR_PATH/backuprestore.json
        if [ $? -eq 0 ];then
            rm -rf $CUR_PATH/backuprestore.json
            # 设置备份存储份数为2
            sed -i 's/DYNAMIC_COUNT=.*/DYNAMIC_COUNT=2/' /opt/oss/manager/var/etc/backuprestore/backuprestore.cfg
            ipmc_adm -cmd restartapp -app UniEPService -tenant manager
            omp_ips=`cat /opt/oss/manager/var/agent/managerip.conf|grep realmanagerip|cut -d= -f 2`
            is_cluster=`echo $omp_ips|grep ,`
            if [ "${is_cluster}X" != "X" ]; then
                omp2_ip=`echo $omp_ips|cut -d, -f 2`
                sh $SSHMGRPATH/sshmgr.sh -exectype cmd -ip $omp2_ip -cmd ". /opt/oss/manager/agent/bin/engr_profile.sh && sed -i 's/DYNAMIC_COUNT=.*/DYNAMIC_COUNT=2/' /opt/oss/manager/var/etc/backuprestore/backuprestore.cfg && ipmc_adm -cmd restartapp -app UniEPService -tenant manager"
                if [ $? -ne 0 ]; then
                    exit 1
                fi
            fi
        else
            rm -rf $CUR_PATH/backuprestore.json
            echo "ftp.check.failed"
            exit 1
        fi
    fi
}

function main()
{
    set_ftp
}

main
