#!/bin/bash
CUR_PATH=$(dirname $(readlink -f $0))
for i in {1..3}
do
    [[ ${1#-} == "input" ]] && { custom_input=$2;shift 2;continue; }
done

product_name="NCECAMPUS"
scene="cluster"

if [[ -e $CUR_PATH/pyscripts/modify_product_info.py ]]
then
    modify_product_info="$CUR_PATH/pyscripts/modify_product_info.py"
else
    modify_product_info="$CUR_PATH/pyscripts/modify_product_info.pyc"
fi
cp $CUR_PATH/pwuser.json /tmp
. /opt/oss/manager/agent/bin/engr_profile.sh

# Common后置lock脚本不执行
if [ -f "${CUR_PATH}/../NCE-Common/post_upgrade_lock.sh" ];then
    mv ${CUR_PATH}/../NCE-Common/post_upgrade_lock.sh ${CUR_PATH}/../NCE-Common/bak_post_upgrade_lock.sh
fi

# 升级开始时回收 删除OMP包标记文件
rm -rf /tmp/delete_omp_pkg_success

SU_ROOT=${SUPER_ROOT}
SSHMGRPATH="/opt/oss/manager/tools/common/sshmgr"
sh /opt/oss/manager/tools/resmgr/queryproduct.sh -pn all -output ${CUR_PATH}
pn_num=`ls -l ${CUR_PATH}/product_*.json|wc -l`
if [ $pn_num -eq 1 ];then
    iae_mode=$($PYTHONHOME/bin/python -c "import json;f=open('$CUR_PATH/product_$product_name.json','r');obj=json.load(f);f.close();print (obj['productext']['IAE_MODE'])" 2>/dev/null)
    if [ "$iae_mode" == "2" ];then
        scene="iae"
    else
        node_num=`grep -o "\"nodemgrip\":" $CUR_PATH/nodes_$product_name.json |wc -l`
        if [ $node_num -eq 1 ];then
            scene="single"
            id omm >/dev/null 2>&1
            if [ $? -eq 0 ];then
                sudo $SUPER_ROOT/execute.sh $CUR_PATH/campus_sudo_pkg/campus_sudo_pkg.tar /tmp/start_fi start_fi.sh >/dev/null 2>&1
                sleep 120
            fi
        fi
    fi
fi

function pre_oprate()
{
    local upgrade_product_list=$($PYTHONHOME/bin/python -c "import json;f=open('${custom_input}','r');obj=json.load(f);f.close();print (obj['productlist'])" 2>/dev/null)
    echo ${upgrade_product_list[@]} | grep "manager" 2>/dev/null
    if [ $? -eq 0 ]; then
        sh /opt/oss/manager/tools/resmgr/queryproduct.sh -pn manager -output ${CUR_PATH}
    fi
    upgrade_product_list=($(echo $upgrade_product_list | awk -F"[][,']" '{for(i=1; i<=NF; i++) print $i}'))

    local all_nodes_ip=()
    for product in ${upgrade_product_list[@]}
    do
        product_node_list=($(cat ${CUR_PATH}/nodes_${product}.json | python -m json.tool | grep "nodemgrip" | cut -d\" -f4))
        all_nodes_ip=(${all_nodes_ip[@]} ${product_node_list[@]})
    done

    all_nodes_ip=($(echo ${all_nodes_ip[@]} | sed 's/ /\n/g' | sort | uniq))

    echo "all node ip is:${all_nodes_ip[*]}"

    sh /opt/oss/manager/tools/common/queryompip.sh -output ${CUR_PATH}
    time_sync_server=`$PYTHONHOME/bin/python -c "import json;f=open('${CUR_PATH}/ompip.json','r');obj=json.load(f);f.close();print (obj['OMPMgmtIP'])"`
    time_sync_server=`echo ${time_sync_server} | awk -F ':' '{print $1}'`
    if [ ${pn_num} -eq 1 ]; then
        grep "FIMANAGER_IP" $CUR_PATH/product_$product_name.json
        if [ $? -eq 0 ]; then
            local FIMANAGER_IP=$($PYTHONHOME/bin/python -c "import json;f=open('$CUR_PATH/product_$product_name.json','r');obj=json.load(f);f.close();print (obj['productext']['FIMANAGER_IP'])" 2>/dev/null)
            if [ "${FIMANAGER_IP}X" != "X" ]; then
                time_sync_server=${FIMANAGER_IP}
            fi
        fi
    fi

    for node_ip in ${all_nodes_ip[*]}
    do
        echo "execute ip: ${node_ip}"
        sh $SSHMGRPATH/sshmgr.sh -exectype put -ip ${node_ip} -source $CUR_PATH/upgrade_sudo_pkg/upgrade_sudo_pkg.tar -target /tmp

        sh $SSHMGRPATH/sshmgr.sh -exectype cmd -ip $node_ip -cmd ". /opt/oss/manager/agent/bin/engr_profile.sh && sudo $SUPER_ROOT/execute.sh /tmp/upgrade_sudo_pkg.tar /tmp/copy_sync_time copy_sync_time.sh ${time_sync_server}"
        if [ $? -ne 0 ]; then
            echo "[${node_ip}] execute copy_sync_time.sh failed."
            exit 1
        fi

        sh $SSHMGRPATH/sshmgr.sh -exectype cmd -ip $node_ip -cmd ". /opt/oss/manager/agent/bin/engr_profile.sh && sudo $SUPER_ROOT/execute.sh /tmp/upgrade_sudo_pkg.tar /tmp/copy_fault_recovery copy_fault_recovery.sh"
        if [ $? -ne 0 ]; then
            echo "[${node_ip}] execute copy_fault_recovery.sh failed."
            exit 1
        fi

        sh $SSHMGRPATH/sshmgr.sh -exectype cmd -ip ${node_ip} -cmd ". /opt/oss/manager/agent/bin/engr_profile.sh && sudo $SUPER_ROOT/execute.sh /tmp/upgrade_sudo_pkg.tar /tmp/release_dbuser_ssh release_dbuser_ssh.sh"
        if [ $? -ne 0 ]; then
            echo "[${node_ip}] execute release_dbuser_ssh.sh failed."
            exit 1
        fi

        sh $SSHMGRPATH/sshmgr.sh -exectype cmd -ip $node_ip -cmd ". /opt/oss/manager/agent/bin/engr_profile.sh && sudo $SU_ROOT/execute.sh /tmp/upgrade_sudo_pkg.tar /tmp/stop_lock stop_lock.sh"
        if [ $? -ne 0 ]; then
            echo "[${node_ip}] execute stop_lock.sh failed."
            exit 1
        fi

        sh $SSHMGRPATH/sshmgr.sh -exectype cmd -ip $node_ip -cmd "rm -rf /tmp/upgrade_sudo_pkg.tar"
    done
}
pre_oprate

function pre_execute_script()
{
    if [ ! -d $CUR_PATH/pre_upgrade ]; then
        mkdir $CUR_PATH/pre_upgrade
    fi

    if [ -f /opt/oss/upgrade_custom_script/pre_upgrade_script.zip ]; then
        unzip /opt/oss/upgrade_custom_script/pre_upgrade_script.zip -d $CUR_PATH/pre_upgrade
    fi

    find $CUR_PATH/pre_upgrade/pre_upgrade_*.sh  2>/dev/null

    if [ $? -eq 0 ];then
        export product_name=$product_name
        rm -rf $CUR_PATH/pre_upgrade/*.result
        result_arry=()
        # shellcheck disable=SC2231
        for custScript in  $CUR_PATH/pre_upgrade/pre_upgrade_*.sh
        do
            echo "[`date`] call product pre_upgrade ..."
            sh ${custScript} &
            result_arry[${#result_arry[*]}]=${custScript%.sh}.result
        done

        error_arry=()

        for ((i=0; i<180; i++))
        do
            for result in ${result_arry[@]}
            do
                cat $result 2>/dev/null |grep 1 >/dev/null
                if [ $? -eq 0 ];then
                    error_arry=(`echo ${error_arry[@]}` "$result")
                    result_arry=(`echo ${result_arry[@]/$result/}`)
                fi
                cat $result 2>/dev/null |grep 0 >/dev/null
                if [ $? -eq 0 ];then
                    result_arry=(`echo ${result_arry[@]/$result/}`)
                fi
            done
            if [ ${#result_arry[@]} -eq 0 ];then
                break
            fi
            sleep 5
        done

        if [ ${#result_arry[@]} -ne 0 ];then
            echo "pre_upgrade script: ${result_arry[@]%.result} execute timeout, contact Huawei technical support to rectify the fault"
            exit 1
        elif [ ${#error_arry[@]} -ne 0 ]; then
            echo "pre_upgrade script: ${error_arry[@]%.result} execute failed, contact Huawei technical support to rectify the fault"
            exit 1
        fi
    fi
}
pre_execute_script

function change_product_info()
{
    local product_list=(`ls ${CUR_PATH}/product_*.json`)
    for product_file in ${product_list[@]}
    do
        echo ${product_file} | grep "manager" 2>/dev/null
        if [ $? -ne 0 ]; then
            $PYTHONHOME/bin/python $modify_product_info ${product_file}
            bash /opt/oss/manager/tools/resmgr/modifyproductinfo.sh -input ${product_file}
        fi
    done
}
change_product_info


if [[ -e $CUR_PATH/pyscripts/custom_upgrade_param.py ]]
then
    custom_upgrade_param=$CUR_PATH/pyscripts/custom_upgrade_param.py
else
    custom_upgrade_param=$CUR_PATH/pyscripts/custom_upgrade_param.pyc
fi

$PYTHONHOME/bin/python $custom_upgrade_param $custom_input $scene || exit 1