# -*- coding: utf-8 -*-

"""
执行sql语句
"""

import sys
import pyzenith

DB_IP = sys.argv[1]
DB_PORT = sys.argv[2]
DB_PASSWORD = sys.argv[3]
DB_NAME = sys.argv[4]


def exec_sql(sql):
    """
    action     ：发送单条数据库命令
    :sqlStr    ：字符串
    :return    ：执行结果
    """
    try:
        conn = pyzenith.connect(user=DB_NAME, passwd=DB_PASSWORD, host=DB_IP, port=DB_PORT)
        db_cursor = conn.cursor()
        # 执行sql语句
        conn.autocommit(True)
        db_cursor.execute(sql)
        result = db_cursor.fetchall()
        db_cursor.close()
        conn.close()
        return result
    except pyzenith.Error:
        return "connectDbError"


def data_contains(data, data_list):
    """
    判断字符串是否包含在二维数组里
    """
    for element_list in data_list:
        for elements in element_list:
            if data == elements:
                return True
    return False


def check_item():
    """
    check
    """

    check_apid_exist = "select COLUMN_NAME from DB_TAB_COLUMNS where TABLE_NAME ='I_ENTERPRISEAP' \
    and COLUMN_NAME = 'centralApId'"
    sql_result = exec_sql(check_apid_exist)
    if sql_result == "connectDbError":
        print("connect db error")
        return False

    if data_contains("centralApId", sql_result):
        alter_apid = "alter table I_ENTERPRISEAP rename column `centralApId` to `centralapid`"
        exec_sql(alter_apid)
    else:
        print("centralApId not exist in I_ENTERPRISEAP")
        return "Skip"

    check_apmac_exist = "select COLUMN_NAME from DB_TAB_COLUMNS where TABLE_NAME ='I_ENTERPRISEAP' \
    and COLUMN_NAME = 'centralApMac'"
    sql_result = exec_sql(check_apmac_exist)
    if data_contains("centralApMac", sql_result):
        alter_apmac = "alter table I_ENTERPRISEAP rename column `centralApMac` to `centralapmac`"
        exec_sql(alter_apmac)
    else:
        print("centralApMac not exist in I_ENTERPRISEAP")
        return "Skip"

    check_apmac_exist = "select COLUMN_NAME from DB_TAB_COLUMNS where TABLE_NAME ='I_ENTERPRISEAP' \
    and COLUMN_NAME = 'centralApName'"
    sql_result = exec_sql(check_apmac_exist)
    if data_contains("centralApName", sql_result):
        alter_apname = "alter table I_ENTERPRISEAP rename column `centralApName` to `centralapname`"
        exec_sql(alter_apname)
    else:
        print("centralApName not exist in I_ENTERPRISEAP")
        return "Skip"
    return True


def modify():
    """
    check
    """
    update_apid = "UPDATE META_ATTR A SET NAME='centralapid' WHERE A.ID IN (SELECT B.ATTR_ID FROM \
    META_CLASS_TO_ATTR B LEFT JOIN META_CLASS C ON B.CLASS_ID = C.ID WHERE \
    C.NAME = 'EnterpriseAP') AND A.NAME = 'centralApId'"
    sql_result = exec_sql(update_apid)
    if sql_result == "connectDbError":
        print("connect db error")
        return False

    update_apmac = "UPDATE META_ATTR A SET NAME='centralapmac' WHERE A.ID IN (SELECT B.ATTR_ID \
    FROM META_CLASS_TO_ATTR B LEFT JOIN META_CLASS C ON B.CLASS_ID = C.ID \
    WHERE C.NAME = 'EnterpriseAP') AND A.NAME = 'centralApMac'"
    sql_result = exec_sql(update_apmac)
    if sql_result == "connectDbError":
        print("connect db error")
        return False

    update_apname = "UPDATE META_ATTR A SET NAME='centralapname' WHERE A.ID IN (SELECT B.ATTR_ID \
    FROM META_CLASS_TO_ATTR B LEFT JOIN META_CLASS C ON B.CLASS_ID = C.ID WHERE \
    C.NAME = 'EnterpriseAP') AND A.NAME = 'centralApName'"
    sql_result = exec_sql(update_apname)
    if sql_result == "connectDbError":
        print("connect db error")
        return False
    return True


if __name__ == '__main__':
    CHECK_RESULT = check_item()
    if CHECK_RESULT == "Skip":
        sys.exit(0)
    elif not CHECK_RESULT:
        sys.exit(1)

    if not modify():
        sys.exit(1)
