#!/bin/bash
SCRIPT_PATH=$0
CUR_PATH=$(dirname $(readlink -f $0))
RESULT_FILE=${CUR_PATH}/pre_rollback_KernelInstaller.result
IPMC_USER=$(stat -c '%U' "${SCRIPT_PATH}")
CURRENT_USER=$(/usr/bin/id -u -n)
if [ "${IPMC_USER}" != "${CURRENT_USER}" ];then
    echo "only ${IPMC_USER} can execute this script."
    echo 1 >> ${RESULT_FILE}
    exit 1
fi

function kernelinstall()
{
    CLOUDBASE_PATH="/opt/oss/manager/var/share/CloudBase"
    if [ ! -d "$CLOUDBASE_PATH" ]; then
        echo "[Info] $CLOUDBASE_PATH not exist, nothing to do."
        return 0
    fi
    for fileName in `ls "$CLOUDBASE_PATH" | grep "actions.json"`
    do
        version=${fileName%_actions.json}
        preVersion=${version%.*}
        # check whether CloudBase version is [22.10.X]
        if [[ ${preVersion} != "22.10" ]];then
            echo "[Info] not target verison, nothing to do."
            continue
        fi
        filePath="$CLOUDBASE_PATH/$fileName"
        grep '"0", "1", "0", "1"' $filePath || grep '"0","1","0","1"' $filePath >/dev/null 2>&1
        if [ $? != 0 ];then
            echo "[Info] configuration is right, nothing to do."
            continue
        fi
        sed -i 's/"0", "1", "0", "1"/"0", "1"/g' $filePath >/dev/null 2>&1
        sed -i 's/"0","1","0","1"/"0","1"/g' $filePath >/dev/null 2>&1
        sed -i 's/{"nodeId":"0","tag":"RW","physicalInstanceName":"managedbsvr-0-999","slot":"999"},{"nodeId":"1","tag":"RW","physicalInstanceName":"managedbsvr-1-999","slot":"999"},//' $filePath >/dev/null 2>&1
    done
}

kernelinstall
echo 0 >> ${RESULT_FILE}






