"""
create nodetag
"""
# -*- coding: utf-8 -*

import sys
import json


def main():
    """
    main method
    """
    node_tag_template = sys.argv[1]
    out_json = sys.argv[2]
    product_name = sys.argv[3]

    fr_node_tag = open(node_tag_template, 'r')
    json_tag = json.loads(fr_node_tag.read())
    fr_node_tag.close()

    fr_nodelist = open('/opt/oss/manager/etc/sysconf/nodelists.json', 'r')
    nodelist_json = json.loads(fr_nodelist.read())
    fr_nodelist.close()

    node_id_list = []
    for node_id, node_info in nodelist_json["nodeList"].items():
        if node_info["assignedToTenancy"] == product_name:
            node_id_list.append(int(node_id))
    node_id_list.sort()
    json_input = json.loads('{"node": []}')

    # 定制节点标签，将目标版本的节点规划node_plan_*.json
    node_tags = json_input["node"]
    for node_index in range(1, len(node_id_list) + 1):
        node_tags.append({
            "nodeName": nodelist_json["nodeList"][str(node_id_list[node_index - 1])]["hostname"],
            "destTags": json_tag[0]["node" + str(node_index)].replace(
                "{{regionAlias}}", product_name).split(",")
        })

    json_string = json.dumps(json_input, indent=4, separators=(',', ': '))
    fw_out = open(out_json, 'w')
    fw_out.write(json_string)
    fw_out.close()


main()
