# -*- coding: utf-8 -*-

"""
执行sql语句
"""

import sys
import time
import pyzenith

DB_IP = sys.argv[1]
DB_PORT = sys.argv[2]
DB_PASSWORD = sys.argv[3]
DB_NAME = sys.argv[4]
OPERATION = sys.argv[5]


def exec_sql(sql):
    """
    action     ：发送单条数据库命令
    :sqlStr    ：字符串
    :return    ：执行结果
    """
    try:
        conn = pyzenith.connect(user=DB_NAME, passwd=DB_PASSWORD, host=DB_IP, port=DB_PORT)
        db_cursor = conn.cursor()
        # 执行sql语句
        conn.autocommit(True)
        db_cursor.execute(sql)
        result = db_cursor.fetchall()
        db_cursor.close()
        conn.close()
        return result
    except pyzenith.Error:
        return "connectDbError"


def creat_portallog_index():
    """
    创建认证日志表的索引
    """
    creat_portallog_index_sql = "CREATE INDEX IX_PLDEVICEGROUPIDAUTHENTIME " \
                            "ON T_CAMPUS_PORTALLOG (DEVICEGROUPID,AUTHENTIME)"
    # 每个认证日志索引创建失败重试3次
    count = 0
    while count < 3:
        sql_result = exec_sql(creat_portallog_index_sql)
        if sql_result == "connectDbError":
            count = count + 1
            time.sleep(5)
        else:
            break
    if count == 3:
        print("executeFailed")
    else:
        print("executeSuccess")


def creat_radiusauth_index():
    """
    创建认证日志表的索引
    """
    creat_radiusauth_index_sql = "CREATE INDEX IX_RDAUDEVICEGROUPIDAUTHENTIME " \
                             "ON T_CAMPUS_RADIUSAUTH (DEVICEGROUPID,AUTHENTIME)"
    # 每个认证日志索引创建失败重试3次
    count = 0
    while count < 3:
        sql_result = exec_sql(creat_radiusauth_index_sql)
        if sql_result == "connectDbError":
            count = count + 1
            time.sleep(5)
        else:
            break
    if count == 3:
        print("executeFailed")
    else:
        print("executeSuccess")


def creat_radiusacc_index():
    """
    创建认证日志表的索引
    """
    creat_radiusacc_index_sql = "CREATE INDEX IX_RDACDEVICEGROUPIDACCINITTIME " \
                            "ON T_CAMPUS_RADIUSACC (DEVICEGROUPID,ACCINITTIME)"
    count = 0
    # 每个认证日志索引创建失败重试3次
    while count < 3:
        sql_result = exec_sql(creat_radiusacc_index_sql)
        if sql_result == "connectDbError":
            count = count + 1
            time.sleep(5)
        else:
            break
    if count == 3:
        print("executeFailed")
    else:
        print("executeSuccess")


def check_portallog_index():
    """
    检查portal认证日志表的索引是否存在
    """
    check_portallog_exist = "select INDEX_NAME from SYS.ADM_INDEXES where TABLE_NAME = 'T_CAMPUS_PORTALLOG'"
    # 每个认证日志索引检查失败重试3次
    count = 0
    while count < 3:
        sql_result = exec_sql(check_portallog_exist)
        if sql_result == "connectDbError":
            count = count + 1
            time.sleep(5)
        else:
            if data_contains("IX_PLDEVICEGROUPIDAUTHENTIME", sql_result):
                print("Exist")
            else:
                print("noExist")
            break
    if count == 3:
        print("executeFailed")


def check_radiusauth_index():
    """
    检查radius认证日志表的索引是否存在
    """
    check_radiusauth_exist = "select INDEX_NAME from SYS.ADM_INDEXES where TABLE_NAME = 'T_CAMPUS_RADIUSAUTH'"
    # 每个认证日志索引检查失败重试3次
    count = 0
    while count < 3:
        sql_result = exec_sql(check_radiusauth_exist)
        if sql_result == "connectDbError":
            count = count + 1
            time.sleep(5)
        else:
            if data_contains("IX_RDAUDEVICEGROUPIDAUTHENTIME", sql_result):
                print("Exist")
            else:
                print("noExist")
            break
    if count == 3:
        print("executeFailed")


def check_radiusacc_index():
    """
    检查radius计费日志表的索引是否存在
    """
    check_radiusacc_exist = "select INDEX_NAME from SYS.ADM_INDEXES where TABLE_NAME = 'T_CAMPUS_RADIUSACC'"
    # 每个认证日志索引检查失败重试3次
    count = 0
    while count < 3:
        sql_result = exec_sql(check_radiusacc_exist)
        if sql_result == "connectDbError":
            count = count + 1
            time.sleep(5)
        else:
            if data_contains("IX_RDACDEVICEGROUPIDACCINITTIME", sql_result):
                print("Exist")
            else:
                print("noExist")
            break
    if count == 3:
        print("executeFailed")


def data_contains(data, data_list):
    """
    判断字符串是否包含在二维数组里
    """
    for element_list in data_list:
        for elements in element_list:
            if data == elements:
                return True
    return False


def func_none():
    """
    OPERATION参数无效时调用此方法
    """
    print("cannotFindFunc")


def main():
    """
    fuction entry
    :return:
    """
    func_dict = {}
    func_dict["creat_portallog_index"] = creat_portallog_index
    func_dict["creat_radiusauth_index"] = creat_radiusauth_index
    func_dict["creat_radiusacc_index"] = creat_radiusacc_index
    func_dict["check_portallog_index"] = check_portallog_index
    func_dict["check_radiusauth_index"] = check_radiusauth_index
    func_dict["check_radiusacc_index"] = check_radiusacc_index
    func_dict.get(OPERATION, func_none)()

if __name__ == '__main__':
    main()
