# coding=utf-8
'''
get_zenith_db_info.py
'''
import sys
import json
from util import ossext

DBINSTANCE_NAME = sys.argv[1]
DB_NAME = sys.argv[2]
CONTAINER_JSON = sys.argv[3]
TYPE = ''
if len(sys.argv) == 5:
    TYPE = sys.argv[4]

def get_dbinfo():
    '''
    获取数据库信息
    :return: ip,port,password
    '''
    file = open(CONTAINER_JSON, 'rb')
    db_info = json.load(file)
    keys = list(db_info.keys())
    if TYPE == 'master':
        for key in keys:
            if DBINSTANCE_NAME in key and \
                    db_info[key]["containerType"] == "zenith":
                db_ip = db_info[key]["ip"]
                port = db_info[key]["port"]
                print(str("%s %s" % (db_ip, port)))
                break
    else:
        for key in keys:
            if DBINSTANCE_NAME in key and "dbList" in db_info[key] and \
                    db_info[key]["containerType"] == "zenith":
                db_ip = db_info[key]["ip"]
                port = db_info[key]["port"]
                admin_pptmp = db_info[key]['dbUserPasswd']
                adminpp = ossext.Cipher.decrypt(admin_pptmp)
                print(str("%s %s %s" % (db_ip, port, adminpp)))
                break

    file.close()

def main():
    '''
    主函数
    :return: error code
    '''
    try:
        get_dbinfo()
        return 0
    except (IOError, KeyError) as ex:
        print(repr(ex))
        return 1

#执行main方法
sys.exit(main())
