#!/bin/bash

################################################################################
# name    :    get_param
# describe:    give param to serverinfo.json
# parameter list: null
# input      : null
# output  : 0 success 1 failure
# rerurn  : null
# invoker : paramconfig.json
################################################################################

CUR_PATH=$(cd $(dirname $0);pwd)
INSTALL_ROOT="/opt/oss"

#check current user
function checkUser()
{
    local cur_user=`id -un`
    [ ${cur_user} == "ossadm" ] && return 0
    echo "The script must run with ossadm user."
    exit 1
}

function queryParam()
{
    local product_name="NCECAMPUS"
    . "${INSTALL_ROOT}"/manager/bin/engr_profile.sh
    "${INSTALL_ROOT}"/manager/tools/resmgr/queryproduct.sh -pn all -output ${CUR_PATH}
    if [ $? -ne 0 ];then
        exit 2
    fi
    local pn_info=`find ${CUR_PATH} -name "*${product_name}*"`
    if [ "${pn_info}X" == "X" ];then
        exit 2
    else
        if [[ -e $CUR_PATH/check_backup_sftp_server.py ]]
        then
            has_sftp=`$PYTHONHOME/bin/python $CUR_PATH/check_backup_sftp_server.py`
        else
            has_sftp=`$PYTHONHOME/bin/python $CUR_PATH/check_backup_sftp_server.pyc`
        fi
        local pn_num=`ls -l ${CUR_PATH}/product_*.json|wc -l`
        if [ $pn_num -eq 1 ];then
            local iae_mode=$($PYTHONHOME/bin/python -c "import json;f=open('$CUR_PATH/product_$product_name.json','r');obj=json.load(f);f.close();print (obj['productext']['IAE_MODE'])" 2>/dev/null)
            local fi_mgr_ip=""
            local fi_pwd_available="false"
            if [ "$iae_mode" == "2" ];then
                is_iae="TRUE"
            else
                is_iae="FALSE"
                fi_mgr_ip=$($PYTHONHOME/bin/python -c "import json;f=open('$CUR_PATH/product_$product_name.json','r');obj=json.load(f);f.close();print (obj['productext']['FIMANAGER_IP'])" 2>/dev/null)
                fi_mgr_pwd=$($PYTHONHOME/bin/python -c "import json;f=open('$CUR_PATH/product_$product_name.json','r');obj=json.load(f);f.close();print (obj['productext']['FIMANAGER_PASSWD'])" 2>/dev/null)
                fi_mgr_pwd=`$PYTHONHOME/bin/python <<EOF
from util import ossext
de=ossext.Cipher.decrypt("$fi_mgr_pwd")
print(de)
EOF`
                check_FI_pwd "${fi_mgr_ip}" "${fi_mgr_pwd}"
                if [ $? -ne 0 ]
                then
                    fi_pwd_available="true"
                fi
            fi
            local basesm=`cat $CUR_PATH/product_$product_name.json |grep -w basesm`
            local is_seco_installed="FALSE"
            if [ "${basesm}X" != "X" ]; then
                is_seco_installed="TRUE"
            fi

            local ncepol=`cat $CUR_PATH/product_$product_name.json |grep -w ncepol`
            local is_pol_installed="FALSE"
            if [ "${ncepol}X" != "X" ]; then
                is_pol_installed="TRUE"
            fi
			
            local nmap=`cat $CUR_PATH/product_$product_name.json |grep -w nmap`
            local is_nmap_installed="FALSE"
            if [ "${nmap}X" != "X" ]; then
                is_nmap_installed="TRUE"
            fi

            local sdwan=`cat $CUR_PATH/product_$product_name.json |grep -w sdwan`
            local has_sdwan="false"
            if [ "${sdwan}X" != "X" ]; then
                has_sdwan="true"
            fi            
            echo "{
    \"product\": \"NCE-Campus\",
    \"deployment_plan\": \"c02\",
    \"sceneid\": \"NCE-Campus\",
    \"is_iae\": \"${is_iae}\",
    \"is_seco_installed\": {\"${product_name}\": \"${is_seco_installed}\"},
    \"is_pol_installed\": {\"${product_name}\": \"${is_pol_installed}\"},
    \"is_nmap_installed\": {\"${product_name}\": \"${is_nmap_installed}\"},
    \"fi_mgr_ip\": \"${fi_mgr_ip}\",
    \"fi_pwd_available\": \"${fi_pwd_available}\",
    \"has_sftp\": \"${has_sftp}\",
    \"has_sdwan\": {\"${product_name}\": \"${has_sdwan}\"},
    \"is_campus_pkg\": {\"${product_name}\": \"TRUE\"},
    \"offline_commone\": {\"${product_name}\": \"TRUE\"}
}" > ${CUR_PATH}/serverinfoNCE_Campus.json

        else
            has_sdwan=""
            is_seco_installed=""
            is_pol_installed=""
            is_nmap_installed=""
            is_campus_pkg=""
            echo "{
    \"product\": \"NCE-Campus\",
    \"deployment_plan\": \"c03\",
    \"sceneid\": \"NCE-Campus\",
    \"has_sftp\": \"${has_sftp}\",
    \"is_iae\": \"${is_iae}\",
    \"offline_commone\": {\"${product_name}\": \"TRUE\"}," > ${CUR_PATH}/serverinfoNCE_Campus.json

            for (( i = 0; i < $pn_num; i++ ));
            do
                if [ $i == 0 ];then
                    has_sdwan="${has_sdwan}\"NCECAMPUS-GLOBAL\": \"FLASE\","
                    seco_installed=`check_feture_installed NCECAMPUS basesm`
                    is_seco_installed="${is_seco_installed}\"NCECAMPUS-GLOBAL\": \"FLASE\","
                    is_pol_installed="${is_pol_installed}\"NCECAMPUS-GLOBAL\": \"FLASE\","
                    is_nmap_installed="${is_nmap_installed}\"NCECAMPUS-GLOBAL\": \"FLASE\","
                    is_campus_pkg="${is_campus_add_pkg}\"NCECAMPUS-GLOBAL\": \"TRUE\","
                elif [ $i == 1 ];then
                    sdwan_installed=`check_feture_installed NCECAMPUS sdwan`
                    has_sdwan="${has_sdwan}\"NCECAMPUS\": \"${sdwan_installed}\","
                    is_campus_pkg="${is_campus_pkg}\"NCECAMPUS\": \"TRUE\","
                    seco_installed=`check_feture_installed NCECAMPUS basesm`
                    is_seco_installed="${is_seco_installed}\"NCECAMPUS\": \"${seco_installed}\","
                    pol_installed=`check_feture_installed NCECAMPUS ncepol`
                    is_pol_installed="${is_pol_installed}\"NCECAMPUS\": \"${pol_installed}\","
                    nmap_installed=`check_feture_installed NCECAMPUS nmap`
                    is_nmap_installed="${is_nmap_installed}\"NCECAMPUS\": \"${nmap_installed}\","
                else
                    product_name="NCECAMPUS-$((i-1))"
                    sdwan_installed=`check_feture_installed "${product_name}" sdwan`
                    has_sdwan="${has_sdwan}\"${product_name}\": \"${sdwan_installed}\","
                    is_campus_pkg="${is_campus_pkg}\"${product_name}\": \"TRUE\","
                    seco_installed=`check_feture_installed "${product_name}" basesm`
                    is_seco_installed="${is_seco_installed}\"${product_name}\": \"${seco_installed}\","
                    pol_installed=`check_feture_installed "${product_name}" ncepol`
                    is_pol_installed="${is_pol_installed}\"${product_name}\": \"${pol_installed}\","
                    nmap_installed=`check_feture_installed "${product_name}" nmap`
                    is_nmap_installed="${is_nmap_installed}\"${product_name}\": \"${nmap_installed}\","
                fi
            done
	    echo "    \"is_seco_installed\": {${is_seco_installed%,}}," >> ${CUR_PATH}/serverinfoNCE_Campus.json
            echo "    \"is_pol_installed\": {${is_pol_installed%,}}," >> ${CUR_PATH}/serverinfoNCE_Campus.json
            echo "    \"is_nmap_installed\": {${is_nmap_installed%,}}," >> ${CUR_PATH}/serverinfoNCE_Campus.json
            echo "    \"is_campus_pkg\": {${is_campus_pkg%,}}," >> ${CUR_PATH}/serverinfoNCE_Campus.json
            echo "    \"has_sdwan\": {${has_sdwan%,}}
}" >> ${CUR_PATH}/serverinfoNCE_Campus.json

        fi
        echo 0
    fi
}

function check_feture_installed()
{
    local pro_name=$1
    local feture_name=$2
    local feture_installed="FALSE"
    local feture_info=`cat $CUR_PATH/product_$pro_name.json |grep -w $feture_name`
    if [ "${feture_info}X" != "X" ]; then
        feture_installed="TRUE"
    fi
    echo $feture_installed
}

checkUser
queryParam
