#!/bin/bash

CUR_PATH=$(dirname $(readlink -f $0))
. /opt/oss/manager/bin/engr_profile.sh
product_name="NCECAMPUS"

bash /opt/oss/manager/agent/DRMgrService/tools/drmgr/getsitestatus.sh -pn ${product_name} -output /opt/oss/${product_name}/deploy/conf/sitestatus.conf
disaster_master=`grep -w "local" /opt/oss/${product_name}/deploy/conf/sitestatus.conf | awk -F 'local":' '{print $2}' | awk -F "[\"\"]" '{print $2}'`

echo "${disaster_master}" >> /opt/oss/${product_name}/deploy/conf/dr_status.flag

if [ "${disaster_master}X" == "standbyX" ]; then
    echo "Slave" > /opt/oss/${product_name}/deploy/conf/dr_status.flag
    ipmc_adm -cmd disable -app LVSService -nodeip global
else
    echo "Master" > /opt/oss/${product_name}/deploy/conf/dr_status.flag
fi