#!/bin/bash
CUR_PATH=$(dirname $(readlink -f $0))
for i in {1..3}
do
    [[ ${1#-} == "input" ]] && { planpath=$2;shift 2;continue; }
    [[ ${1#-} == "output" ]] && { output=$2;shift 2;continue; }
done

. /opt/oss/manager/agent/bin/engr_profile.sh

plan_file=$planpath/plandata.json
product_name=$($PYTHONHOME/bin/python -c "import json;f=open('$plan_file','r');obj=json.load(f);f.close();print (obj['productname'])")
node_num=`grep -o "\"nodemgrip\":" $planpath/nodes_$product_name.json |wc -l`

function feature_plan()
{
    cp $CUR_PATH/feature_plan_demo.json $output/feature_plan_$product_name.json
}

function node_plan()
{
    case $node_num in
    1)
        nodetagTemplate="nodetag_1.json"
        ;;
    3)
        nodetagTemplate="nodetag_3.json"
        ;;
    4)
        nodetagTemplate="nodetag_4.json"
        ;;
    6)
        nodetagTemplate="nodetag_6_dis.json"
        ;;
    7)
        nodetagTemplate="nodetag_7.json"
        ;;
    8)
        nodetagTemplate="nodetag_8_dis.json"
        ;;
    12)
        nodetagTemplate="nodetag_12_dis.json"
        ;;
    16)
        nodetagTemplate="nodetag_16_dis.json"
        ;;
    20)
        nodetagTemplate="nodetag_20_dis.json"
        ;;
    *)
        nodetagTemplate=""
    esac

    if [[ "${product_name}" == "NCECAMPUS-GLOBAL" ]]; then
        nodetagTemplate="nodetag_3_global.json"
    fi

    if [ "${nodetagTemplate}X" == "X" ]; then
        echo "Current software do not support upgrade to this version."
        exit 1
    fi
    if [[ -e $CUR_PATH/pyscripts/create_node_tags.py ]]
    then
        create_node_tags=$CUR_PATH/pyscripts/create_node_tags.py
    else
        create_node_tags=$CUR_PATH/pyscripts/create_node_tags.pyc
    fi

    if [ -e $CUR_PATH/nodetagTemplates/$nodetagTemplate ]; then
        $PYTHONHOME/bin/python $create_node_tags $CUR_PATH/nodetagTemplates/$nodetagTemplate $output/node_plan_$product_name.json $product_name || exit 1
    fi
}

function param_plan()
{
    if [ ${node_num} -eq 1 ]; then
        add_param "FMDeployMode" "SingleProcess"
    fi
    cp $CUR_PATH/param_plan_demo.json $output/param_plan_$product_name.json
}


function add_param()
{
    param_name=$1
    param_value=$2
    $PYTHONHOME/bin/python <<EOF
import json
FILENAME="$CUR_PATH/param_plan_demo.json"
PARAM_ADD = json.load(open(FILENAME, encoding='utf-8'))
param = {"name":"${param_name}", "value":"${param_value}"}
PARAM_ADD["addParams"].append(param)
with open(FILENAME, "w") as outfile:
    json.dump(PARAM_ADD, outfile, indent=4, sort_keys=True)
EOF
}

function main()
{
    feature_plan
    param_plan
    node_plan
}

main