#!/bin/bash
CUR_PATH=$(dirname $(readlink -f $0))
for i in {1..2}
do
    [[ ${1#-} == "input" ]] && { planpath=$2;shift 2;continue; }
done
plan_file=$planpath/plandata.json
. /opt/oss/manager/agent/bin/engr_profile.sh
product_name=$($PYTHONHOME/bin/python -c "import json;f=open('$plan_file','r');obj=json.load(f);f.close();print (obj['productname'])")
SSHMGRPATH="/opt/oss/manager/tools/common/sshmgr"
SU_ROOT=${SUPER_ROOT}
echo "$product_name post rollback ..."

function lock_start()
{
    local all_nodes_ip=`grep maintenance /opt/oss/manager/etc/sysconf/nodelists.json -C4 | grep IP | cut -d\" -f4`
    echo "all node ip is:${all_nodes_ip[*]}"
    for node_ip in ${all_nodes_ip[*]}
    do
        echo "execute ip: ${node_ip}"
        sh $SSHMGRPATH/sshmgr.sh -exectype put -ip $node_ip -source $CUR_PATH/upgrade_sudo_pkg/upgrade_sudo_pkg.tar -target /tmp
        sh $SSHMGRPATH/sshmgr.sh -exectype cmd -ip $node_ip -cmd ". /opt/oss/manager/agent/bin/engr_profile.sh && sudo $SU_ROOT/execute.sh /tmp/upgrade_sudo_pkg.tar /tmp/start_lock start_lock.sh"
        if [ $? -ne 0 ]; then
            echo "[${node_ip}] execute start_lock.sh failed."
            exit 1
        fi
        sh $SSHMGRPATH/sshmgr.sh -exectype cmd -ip $node_ip -cmd "rm -rf /tmp/upgrade_sudo_pkg.tar"
    done
}
lock_start
