#!/bin/bash

#
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
#

CUR_PATH=$(dirname $(readlink -f $0))
LOG=$CUR_PATH/post_upgrade_campusaccountservice_role_bind_$PRODUCT_NAME.log

rm -rf ${LOG}
echo "post upgrade before_campusaccountservice ..." >>${LOG}

touch /tmp/queryRolesBinditionFromAccount.sql
chmod 640 /tmp/queryRolesBinditionFromAccount.sql
touch /tmp/queryRolesFromAccount.sql
chmod 640 /tmp/queryRolesFromAccount.sql
touch /tmp/t_campus_usermgr_user_role.csv
chmod 666 /tmp/t_campus_usermgr_user_role.csv
touch /tmp/t_campus_usermgr_role.csv
chmod 666 /tmp/t_campus_usermgr_role.csv

result=0
function get_node_num() {
  local NODES_NCECAMPUS_FILE=$(ls ${CUR_PATH}/../nodes_${PRODUCT_NAME}.json)
  local node_num=$(grep -o "\"nodemgrip\":" ${NODES_NCECAMPUS_FILE} | wc -l)
  echo $node_num
}

if [ -f $CUR_PATH/../pyscripts/get_zenith_db_info.py ]; then
  get_dbinfo_script=$CUR_PATH/../pyscripts/get_zenith_db_info.py
else
  get_dbinfo_script=$CUR_PATH/../pyscripts/get_zenith_db_info.pyc
fi

function get_db_instance() {

  db_instance=$1
  if [ "$(get_node_num)" -ge 8 ]; then
    db_instance="PortalService"
  else
    db_instance="CampusCommon"
  fi
  echo $db_instance
}

function get_master_db_instance() {
  db_instance=$1
  . /opt/oss/manager/bin/engr_profile.sh
  master_instance_name=$(/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance -type zenith -tenant $PRODUCT_NAME -s | grep $db_instance | grep Master | awk -F ' ' '{print $3}')
  echo $master_instance_name
}

# Account 表 t_campus_usermgr_accessuser 数据查询角色绑定信息
function dump_account_role_bind() {

  echo "[$(date)] dump_user_role_bind start ..." >>${LOG}

  role_bind_csv_file_name="/tmp/t_campus_usermgr_user_role.csv"
  queryRolesBinditionFromAccount="dump query \"SELECT a.TENANTID,a.ID,a.USERNAME,a.BSID,a.ROLEID FROM T_CAMPUS_USERMGR_ACCESSUSER a WHERE a.ROLEID IS NOT NULL AND a.ROLEID != '' AND (a.USERTYPE =10 OR a.USERTYPE = 13)\" into file '${role_bind_csv_file_name}';"
  echo $queryRolesBinditionFromAccount >>${LOG}
  echo "${queryRolesBinditionFromAccount}" >/tmp/queryRolesBinditionFromAccount.sql

  role_csv_file_name="/tmp/t_campus_usermgr_role.csv"
  queryRolesFromAccount="dump query \"SELECT TENANTID,ID,NAME FROM T_CAMPUS_USERROLE_ROLE \" into file '${role_csv_file_name}';"
  echo $queryRolesFromAccount >>${LOG}
  echo "${queryRolesFromAccount}" >/tmp/queryRolesFromAccount.sql

  db_instance=$(get_db_instance "CampusAccountService")
  master_db_instance=$(get_master_db_instance $db_instance)
  echo "node number is : $(get_node_num) db_instance is: $db_instance, master_db_instance is: $master_db_instance" >>${LOG}
  dbinfo=($($PYTHONHOME/bin/python $get_dbinfo_script $db_instance "campusaccountdb" $CONTAINER_JSON))
  master_dbinfo=($($PYTHONHOME/bin/python $get_dbinfo_script $master_db_instance "campusaccountdb" $CONTAINER_JSON "master"))
  sudo -u dbuser bash -c "source /home/dbuser/.bashrc && /opt/zenith/app/bin/zsql campusaccountdb/${dbinfo[2]}@${master_dbinfo[0]}:${master_dbinfo[1]} -f /tmp/queryRolesBinditionFromAccount.sql" >>${LOG}
  sudo -u dbuser bash -c "source /home/dbuser/.bashrc && /opt/zenith/app/bin/zsql campusaccountdb/${dbinfo[2]}@${master_dbinfo[0]}:${master_dbinfo[1]} -f /tmp/queryRolesFromAccount.sql" >>${LOG}

  echo "[$(date)] dump_user_role_bind end ..." >>${LOG}
}

dump_account_role_bind
echo $result >$CUR_PATH/post_upgrade_campusaccountservice_ad_role_dump.result
rm /tmp/queryRolesBinditionFromAccount.sql
rm /tmp/queryRolesFromAccount.sql
