#!/bin/bash
CUR_PATH=$(dirname $(readlink -f $0))
. $CUR_PATH/es_logutil.sh
for i in {1..2}
do
    [[ ${1#-} == "input" ]] && { planpath=$2;shift 2;continue; }
done
plan_file=$planpath/plandata.json
. /opt/oss/manager/agent/bin/engr_profile.sh

if [[ -e $CUR_PATH/pyscripts/start_product.py ]]
then
    start_product="$CUR_PATH/pyscripts/start_product.py"
else
    start_product="$CUR_PATH/pyscripts/start_product.pyc"
fi

product_name=$($PYTHONHOME/bin/python -c "import json;f=open('$plan_file','r');obj=json.load(f);f.close();print (obj['productname'])")
src_version=$($PYTHONHOME/bin/python -c "import json;f=open('$plan_file','r');obj=json.load(f);f.close();print (obj['src_version'])")
SSHMGRPATH="/opt/oss/manager/tools/common/sshmgr"
SU_ROOT=${SUPER_ROOT}
echo "$product_name post upgrade ..."

if [[ -e $CUR_PATH/pyscripts/export_containerlist.py ]]
then
    export_containerlist="$CUR_PATH/pyscripts/export_containerlist.py"
else
    export_containerlist="$CUR_PATH/pyscripts/export_containerlist.pyc"
fi

$PYTHONHOME/bin/python $export_containerlist $product_name $CUR_PATH/containerlist_$product_name.json
export CONTAINER_JSON=$CUR_PATH/containerlist_$product_name.json
export PRODUCT_NAME=$product_name
export SRC_VERSION=$src_version


function pre_start_product() {
    local upgrade_product_list=("manager" "${product_name}")
    sh /opt/oss/manager/tools/resmgr/queryproduct.sh -pn manager -output ${CUR_PATH}
    sh /opt/oss/manager/tools/resmgr/queryproduct.sh -pn ${product_name} -output ${CUR_PATH}

    local all_nodes_ip=()

    for product in ${upgrade_product_list[@]}
    do
        product_node_list=($(cat ${CUR_PATH}/nodes_${product}.json | python -m json.tool | grep "nodemgrip" | cut -d\" -f4))
        all_nodes_ip=(${all_nodes_ip[@]} ${product_node_list[@]})
    done

    all_nodes_ip=($(echo ${all_nodes_ip[@]} | sed 's/ /\n/g' | sort | uniq))

    echo "all node ip is:${all_nodes_ip[*]}"

    for node_ip in ${all_nodes_ip[*]}
    do
        echo "execute ip: ${node_ip}"
        sh $SSHMGRPATH/sshmgr.sh -exectype put -ip $node_ip -source $CUR_PATH/upgrade_sudo_pkg/upgrade_sudo_pkg.tar -target /tmp

        sh $SSHMGRPATH/sshmgr.sh -exectype cmd -ip $node_ip -cmd ". /opt/oss/manager/agent/bin/engr_profile.sh && sudo $SU_ROOT/execute.sh /tmp/upgrade_sudo_pkg.tar /tmp/change_mode_tmp change_mode_tmp.sh"
        if [ $? -ne 0 ]; then
            echo "[${node_ip}] execute change_mode_tmp.sh failed."
            exit 1
        fi

        sh $SSHMGRPATH/sshmgr.sh -exectype cmd -ip $node_ip -cmd ". /opt/oss/manager/agent/bin/engr_profile.sh && sudo $SUPER_ROOT/execute.sh /tmp/upgrade_sudo_pkg.tar /tmp/recover_dbuser_ssh recover_dbuser_ssh.sh"
        if [ $? -ne 0 ]; then
            echo "[${node_ip}] execute recover_dbuser_ssh.sh failed."
            exit 1
        fi

        sh $SSHMGRPATH/sshmgr.sh -exectype cmd -ip $node_ip -cmd "rm -rf /tmp/upgrade_sudo_pkg.tar"

    done
}

function post_start_lock() {
    local upgrade_product_list=("manager" "${product_name}")
    sh /opt/oss/manager/tools/resmgr/queryproduct.sh -pn manager -output ${CUR_PATH}
    sh /opt/oss/manager/tools/resmgr/queryproduct.sh -pn ${product_name} -output ${CUR_PATH}

    local all_nodes_ip=()

    for product in ${upgrade_product_list[@]}
    do
        product_node_list=($(cat ${CUR_PATH}/nodes_${product}.json | python -m json.tool | grep "nodemgrip" | cut -d\" -f4))
        all_nodes_ip=(${all_nodes_ip[@]} ${product_node_list[@]})
    done

    all_nodes_ip=($(echo ${all_nodes_ip[@]} | sed 's/ /\n/g' | sort | uniq))

    echo "all node ip is:${all_nodes_ip[*]}"

    for node_ip in ${all_nodes_ip[*]}
    do
        echo "execute ip: ${node_ip}"
        sh $SSHMGRPATH/sshmgr.sh -exectype put -ip $node_ip -source $CUR_PATH/upgrade_sudo_pkg/upgrade_sudo_pkg.tar -target /tmp

        sh $SSHMGRPATH/sshmgr.sh -exectype cmd -ip $node_ip -cmd ". /opt/oss/manager/agent/bin/engr_profile.sh && sudo $SU_ROOT/execute.sh /tmp/upgrade_sudo_pkg.tar /tmp/start_lock start_lock.sh"
        if [ $? -ne 0 ]; then
            echo "[${node_ip}] execute start_lock.sh failed."
            exit 1
        fi
        sh $SSHMGRPATH/sshmgr.sh -exectype cmd -ip $node_ip -cmd "rm -rf /tmp/upgrade_sudo_pkg.tar"
    done
}

function deal_fimanager()
{
    local node_num=`grep -o "\"nodemgrip\":" $planpath/nodes_$product_name.json |wc -l`
    id omm >/dev/null 2>&1
    if [[ $? -eq 0 && $node_num -eq 1 ]]
    then
        sudo $SUPER_ROOT/execute.sh $CUR_PATH/upgrade_sudo_pkg/upgrade_sudo_pkg.tar /tmp/stop_fi stop_fi.sh
        es_log "INFO" "stop fi manager for single node success."
    fi
}


function disable_lvs()
{
    if [ -e "/opt/oss/${product_name}/deploy/conf/dr_status.flag" ]; then
        disaster_master=`cat /opt/oss/${product_name}/deploy/conf/dr_status.flag`
        if [ "${disaster_master}X" == "SlaveX" ]; then
            ipmc_adm -cmd disable -app LVSService -nodeip global
        fi
        rm -rf opt/oss/${product_name}/deploy/conf/dr_status.flag
    fi
}

function execute_service_scripts()
{
    execute_path=$1
    check_flag=$2

    if [ ! -d $CUR_PATH/${execute_path} ]; then
        mkdir $CUR_PATH/${execute_path}
    fi

    if [ -f /opt/oss/upgrade_custom_script/${execute_path}.zip ]; then
        unzip /opt/oss/upgrade_custom_script/${execute_path}.zip -d $CUR_PATH/${execute_path}
    fi

    find $CUR_PATH/$execute_path/post_upgrade_*.sh  2>/dev/null

    if [ $? -eq 0 ];then
        rm -rf $CUR_PATH/$execute_path/*.result
        result_arry=()
        # shellcheck disable=SC2231
        for custScript in  $CUR_PATH/$execute_path/post_upgrade_*.sh
        do
            es_log "INFO" "call product $execute_path ..."
            sh ${custScript} &
            result_arry[${#result_arry[*]}]=${custScript%.sh}.result
        done

        if [ "$check_flag" != "without_check" ];then
            for ((i=0; i<720; i++))
            do
                for result in ${result_arry[@]}
                do
                    cat $result 2>/dev/null |grep 1 >/dev/null
                    if [ $? -eq 0 ];then
                        es_log "ERROR" "$execute_path script: ${result%.result} execute failed."
                        exit 1
                    fi
                    cat $result 2>/dev/null |grep 0 >/dev/null
                    if [ $? -eq 0 ];then
                        result_arry=(`echo ${result_arry[@]/$result/}`)
                    fi
                done
                if [ ${#result_arry[@]} -eq 0 ];then
                    es_log "INFO" "all $execute_path script execute successful."
                    break
                fi
                es_log "INFO" "waiting fot all $execute_path script execute successful..."
                sleep 10
            done

            if [ ${#result_arry[@]} -ne 0 ];then
                es_log "ERROR" "$execute_path script: ${result_arry[@]%.result} execute timeout."
                exit 1
            fi
        fi
    fi
}

function start_product()
{
    local start_result=`$PYTHONHOME/bin/python $start_product $product_name "start"`
    if [ "${start_result}" == "success" ];then
        es_log "INFO" "start product..."
        for (( i = 0; i < 1800; i++ ))
        do
            local query_result=`$PYTHONHOME/bin/python $start_product $product_name "query"`
            if [ "${query_result}" == "success" ];then
                es_log "INFO" "product start successful."
                return 0
            elif [ "${query_result}" == "starting" ];then
                sleep 2
            fi
        done
    else
        es_log "ERROR" "start product failed."
        exit 1
    fi
    es_log "ERROR" "product start timeout."
    exit 1
}

disable_lvs
deal_fimanager
pre_start_product

execute_service_scripts "post_upgrade_before"
start_product
post_start_lock

