#!/bin/bash

CUR_PATH=$(dirname $(readlink -f $0))
. /opt/oss/manager/agent/bin/engr_profile.sh
. $CUR_PATH/../es_logutil.sh

DB_TYPE="zenith"
DB_NAME="cmdbcoresvrdb"
SERVICE_NAME="CampusEsight-"
EXCUTE_SQL_SCRIPT="$CUR_PATH/excute_sqlcloudsopdatabase.py"

function decrypt()
{
    . /opt/oss/manager/bin/engr_profile.sh;python <<EOF
from util import ossext;de=ossext.Cipher.decrypt("$1");print(de)
EOF
}

function get_db_info()
{
    db_name=$1

    if [[ -e $CUR_PATH/../pyscripts/get_zenith_db_info.py ]]; then
        GET_DBINFO_SCRIPT="$CUR_PATH/../pyscripts/get_db_conn_info.py"
    else
        GET_DBINFO_SCRIPT="$CUR_PATH/../pyscripts/get_db_conn_info.pyc"
    fi

    db_info=(`$PYTHONHOME/bin/python ${GET_DBINFO_SCRIPT} ${db_name} $CUR_PATH/../containerlist_old_${PRODUCT_NAME}.json`)
}

function modifyAttrName()
{
    # 连数据库后台异步创建索引
    get_db_info ${DB_NAME}
    local dbpasswd=$(decrypt ${db_info[2]})
    /opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance | grep ${SERVICE_NAME} | grep Master | awk '{print $1,$6,$7}' > $CUR_PATH/gaussinsts.txt
    db_info[0]=`cat $CUR_PATH/gaussinsts.txt | awk '{print $2}'`
    db_info[1]=`cat $CUR_PATH/gaussinsts.txt | awk '{print $3}'`
    es_log "INFO" "pre_upgrade_cloudsopdatabase.sh: modify atrr name execute begin"
    $PYTHONHOME/bin/python ${EXCUTE_SQL_SCRIPT} ${db_info[0]} ${db_info[1]} ${dbpasswd} ${DB_NAME} >> $CUR_PATH/pre_upgrade_cloudsopdatabase.log 
    if [ $? -ne 0 ];then
        es_log "ERROR" "[`date`] pre_upgrade_cloudsopdatabase.sh: modify atrr name error"
        echo 1 > $CUR_PATH/pre_upgrade_cloudsopdatabase.result
        exit 1 
    fi
    es_log "INFO" "[`date`] pre_upgrade_cloudsopdatabase.sh: modify atrr name end"
    echo 0 > $CUR_PATH/pre_upgrade_cloudsopdatabase.result
    exit 0
}

modifyAttrName
