#!/bin/bash
for i in {1..2}
do
    [[ ${1#-} == "input" ]] && { planpath=$2;shift 2;continue; }
done
plan_file=$planpath/plandata.json
CUR_PATH=$(dirname $(readlink -f $0))
. /opt/oss/manager/agent/bin/engr_profile.sh

product_name=$($PYTHONHOME/bin/python -c "import json;f=open('$plan_file','r');obj=json.load(f);f.close();print (obj['productname'])")
SSHMGRPATH="/opt/oss/manager/tools/common/sshmgr"
SU_ROOT=${SUPER_ROOT}
echo "$product_name pre rollback ..."

function lock_stop()
{
    local all_nodes_ip=`grep maintenance /opt/oss/manager/etc/sysconf/nodelists.json -C4 | grep IP | cut -d\" -f4`
    echo "all node ip is:${all_nodes_ip[*]}"
    for node_ip in ${all_nodes_ip[*]}
    do
        echo "execute ip: ${node_ip}"
        sh $SSHMGRPATH/sshmgr.sh -exectype put -ip $node_ip -source $CUR_PATH/upgrade_sudo_pkg/upgrade_sudo_pkg.tar -target /tmp
        sh $SSHMGRPATH/sshmgr.sh -exectype cmd -ip $node_ip -cmd ". /opt/oss/manager/agent/bin/engr_profile.sh && sudo $SU_ROOT/execute.sh /tmp/upgrade_sudo_pkg.tar /tmp/stop_lock stop_lock.sh"
        if [ $? -ne 0 ]; then
            echo "[${node_ip}] execute stop_lock.sh failed."
            exit 1
        fi
        sh $SSHMGRPATH/sshmgr.sh -exectype cmd -ip $node_ip -cmd "rm -rf /tmp/upgrade_sudo_pkg.tar"
    done
}
lock_stop

function pre_execute_script()
{
    if [ ! -d $CUR_PATH/pre_rollback ]; then
        mkdir $CUR_PATH/pre_rollback
    fi

    if [ -f /opt/oss/upgrade_custom_script/pre_rollback_script.zip ]; then
        unzip /opt/oss/upgrade_custom_script/pre_rollback_script.zip -d $CUR_PATH/pre_rollback
    fi

    find $CUR_PATH/pre_rollback/pre_rollback_*.sh  2>/dev/null

    if [ $? -eq 0 ];then
        export product_name=$product_name
        rm -rf $CUR_PATH/pre_rollback/*.result
        result_arry=()
        # shellcheck disable=SC2231
        for custScript in  $CUR_PATH/pre_rollback/pre_rollback_*.sh
        do
            echo "[`date`] call product pre_rollback ..."
            sh ${custScript} &
            result_arry[${#result_arry[*]}]=${custScript%.sh}.result
        done

        error_arry=()

        for ((i=0; i<180; i++))
        do
            for result in ${result_arry[@]}
            do
                cat $result 2>/dev/null |grep 1 >/dev/null
                if [ $? -eq 0 ];then
                    error_arry=(`echo ${error_arry[@]}` "$result")
                    result_arry=(`echo ${result_arry[@]/$result/}`)
                fi
                cat $result 2>/dev/null |grep 0 >/dev/null
                if [ $? -eq 0 ];then
                    result_arry=(`echo ${result_arry[@]/$result/}`)
                fi
            done
            if [ ${#result_arry[@]} -eq 0 ];then
                break
            fi
            sleep 5
        done

        if [ ${#result_arry[@]} -ne 0 ];then
            echo "pre_rollback script: ${result_arry[@]%.result} execute timeout, contact Huawei technical support to rectify the fault"
            exit 1
        elif [ ${#error_arry[@]} -ne 0 ]; then
            echo "pre_rollback script: ${error_arry[@]%.result} execute failed, contact Huawei technical support to rectify the fault"
            exit 1
        fi
    fi
}
pre_execute_script
