#!/bin/bash
CUR_PATH=$(dirname $(readlink -f $0))
for i in {1..2}
do
    [[ ${1#-} == "input" ]] && { planpath=$2;shift 2;continue; }
done
plan_file=$planpath/plandata.json
product_name=$($PYTHONHOME/bin/python -c "import json;f=open('$plan_file','r');obj=json.load(f);f.close();print (obj['productname'])")
export PRODUCT_NAME=$product_name
echo "$product_name pre upgrade..."

if [[ -e $CUR_PATH/pyscripts/export_containerlist.py ]]
then
    export_containerlist="$CUR_PATH/pyscripts/export_containerlist.py"
else
    export_containerlist="$CUR_PATH/pyscripts/export_containerlist.pyc"
fi

$PYTHONHOME/bin/python $export_containerlist $product_name $CUR_PATH/containerlist_old_$product_name.json

function pre_execute_script()
{
    if [ ! -d $CUR_PATH/pre_custom_upgrade ]; then
        mkdir $CUR_PATH/pre_custom_upgrade
    fi

    if [ -f /opt/oss/upgrade_custom_script/pre_upgrade_script.zip ]; then
        unzip /opt/oss/upgrade_custom_script/pre_upgrade_script.zip -d $CUR_PATH/pre_custom_upgrade
    fi

    find $CUR_PATH/pre_custom_upgrade/pre_upgrade_*.sh  2>/dev/null

    if [ $? -eq 0 ];then
        rm -rf $CUR_PATH/pre_custom_upgrade/*.result
        result_arry=()
        # shellcheck disable=SC2231
        for custScript in  $CUR_PATH/pre_custom_upgrade/pre_upgrade_*.sh
        do
            echo "[`date`] call product pre_custom_upgrade ..."
            sh ${custScript} &
            result_arry[${#result_arry[*]}]=${custScript%.sh}.result
        done

        error_arry=()

        for ((i=0; i<180; i++))
        do
            for result in ${result_arry[@]}
            do
                cat $result 2>/dev/null |grep 1 >/dev/null
                if [ $? -eq 0 ];then
                    error_arry=(`echo ${error_arry[@]}` "$result")
                fi
                cat $result 2>/dev/null |grep 0 >/dev/null
                if [ $? -eq 0 ];then
                    result_arry=(`echo ${result_arry[@]/$result/}`)
                fi
            done
            if [ ${#result_arry[@]} -eq 0 ];then
                break
            fi
            sleep 5
        done

        if [ ${#result_arry[@]} -ne 0 ];then
            echo "pre_custom_upgrade script: ${result_arry[@]%.result} execute timeout, contact Huawei technical support to rectify the fault"
            exit 1
        elif [ ${#error_arry[@]} -ne 0 ]; then
            echo "pre_custom_upgrade script: ${error_arry[@]%.result} execute failed, contact Huawei technical support to rectify the fault"
            exit 1
        fi
    fi
}
pre_execute_script

