"""
custom upg param
"""
# -*- coding: utf-8 -*
import sys
import json

def main():
    """
    main method
    """
    custom_input = sys.argv[1]
    scene = sys.argv[2]

    fr_custom_input = open(custom_input, 'r')
    json_custom_input = json.loads(fr_custom_input.read())
    fr_custom_input.close()

    fr_output = open(json_custom_input['manager'], 'r')
    json_output = json.loads(fr_output.read())
    fr_custom_input.close()

    json_output["upgrade_omp_params"].append("-pkglist")
    if scene == "single":
        pkglist = "pkglist_single_no_ems.conf,pkglist_campus.conf,pkglist_es_enter.conf"
    elif scene == "iae":
        pkglist = "pkglist_single_no_ems.conf,pkglist_IAE.conf,pkglist_es_enter.conf"
    else:
        pkglist = "pkglist_default_no_ems.conf,pkglist_campus.conf,pkglist_es_enter.conf"

    json_output["upgrade_omp_params"].append(pkglist)
    json_string = json.dumps(json_output, indent=4, separators=(',', ': '))
    fw_out = open(json_custom_input['manager'], 'w')
    fw_out.write(json_string)
    fw_out.close()


main()
