# encoding=utf-8
"""
功 能：方案和参数规划校验参数
版权信息：华为技术有限公司，版本所有(C) 2019-2029
修改记录：2019-12-11 12:00 创建
"""
import os
import subprocess
import logging
import json
from easysuite import settings
from utils.i18n import i18nDict

LOCAL_LOGGER = logging.getLogger(__name__)
CHECK_CMD_RESUT = " && echo es.check.success || echo es.check.failed"


def exe(kvs):
    """
    功能说明:检验升级参数
    :param kvs
    :return 校验成功返回200, '';失败返回 500, 附上国际化后的报错信息
    """

    domain_base_path = os.path.join(settings.PKG_CFG_DIR, 'NCE-Campus', 'upgrade_online', 'website')
    local_domain_plugin_path = os.path.join(settings.PKG_CFG_DIR, 'NCE-Campus', 'upgrade_online',
                                            'website', 'plandata', 'check_param')
    cmd = "rm -rf /tmp/check_param; cp -r %s /tmp" % local_domain_plugin_path
    os.system(cmd)
    i18_res = i18nDict(domain_base_path)
    default_return = {'status': 'failed', 'item_result': 'error'}

    # 检查上传的软件包与环境是否匹配
    check_package_result, default_return = check_package(kvs, default_return, i18_res)
    if check_package_result != 0:
        return 500, default_return

    check_package_result, default_return = execute_script(default_return, i18_res)
    if check_package_result != 0:
        return 500, default_return

    delete_omp_pkg()
    modify_second_param(kvs)

    has_sdwan = kvs.get('has_sdwan')
    patch_version = kvs.get('des_version')
    product_list = []
    if len(kvs.get('product_name')) == 1:
        product_list.append("NCECAMPUS")
    else:
        for src in kvs.get('src_version'):
            product_name = src.split("(")[1].split(")")[0]
            product_list.append(product_name)

    if "NCECAMPUS-GLOBAL" in product_list and ('YIP' in patch_version or 'WXFJ' in patch_version):
        default_return.update({'item_result': i18_res.get('check_global_err')})
        return 500, default_return
    if 'YIP' in patch_version:
        for product_name in product_list:
            if has_sdwan[product_name] == "FALSE":
                error_info = "[%s]-%s" % (product_name, i18_res.get('check_yip_err'))
                default_return.update({'item_result': error_info})
                return 500, default_return
    cmd = 'echo \'%s\' | sh /tmp/check_param/check_param.sh ' \
          % (kvs.get('ftpuser_pwd'))

    if kvs.get('ftpuser_pwd') != "":
        status, result = subprocess.getstatusoutput(cmd)
        if status != 0:
            if result == "ftp.check.failed":
                default_return.update({'item_result': i18_res.get('check_param_backup_err')})
            return 500, default_return

    return 200, ''


def check_easysuite_version(default_return, i18_res):
    """ 校验EasySuite版本是否升级 """

    cmd = "cat  /opt/oss/easysuite/easysuite/easysuite/version.ini | grep release_version | awk -F '=' '{print $2}'"

    if os.path.exists("/opt/oss/easysuite/easysuite/easysuite/version.ini"):
        status, result = subprocess.getstatusoutput(cmd)
        log = "The easysutie version is %s, The easysutie version is %s, need upgrade." % (status, result)
        LOCAL_LOGGER.error(log)
        if status == 0:
            if result != "V100R021C00SPC917":
                default_return.update({'item_result': i18_res.get('check_easysuit_version_err')})
                return 500, default_return
    return 0, ''

def delete_omp_pkg():
    """ 删除同版本omp """
    # 升级回滚再升级同版本场景，删除原omp包规避扫描失败问题
    config_path = os.path.join(settings.PKG_CFG_DIR, 'NCE-Campus', 'upgrade_online',
                               'website', 'data', 'upgradeconfig.json')
    with open(config_path, "r", encoding='utf-8') as jsonfile:
        data = json.load(jsonfile)
    delete_pkgs = ""
    for pkg in data["upgradeconfig"][0]["packages"]:
        if "_OMP" in pkg["packagename"]:
            delete_pkgs += pkg["packagename"] + ","
        if "GaussDBPatch" in pkg["packagename"]:
            os.system('. /opt/oss/manager/agent/bin/engr_profile.sh ' \
                      '&& echo "' + pkg["internal_package_name"] + \
                      '" > $SHAREPATH/dbpatchname')
    delete_pkgs = delete_pkgs[:-1]
    cmd = 'sh /tmp/check_param/delete_omp_pkg.sh %s' % delete_pkgs
    os.system(cmd)


def check_package(kvs, default_return, i18_res):
    """
    :param i18_res:
    :param default_return:
    :param kvs:
    :return:
    """

    architecture = subprocess.getoutput("uname -i")
    server_arch = kvs.get("os_cpu_type")
    is_iae = kvs.get("is_iae")
    if architecture != server_arch:
        log = "The server architecture is %s, but software package is %s, which is not match to " \
              "the server architecture." % (architecture, server_arch)
        LOCAL_LOGGER.error(log)
        default_return.update({'item_result': i18_res.get('check_package_err1')})
        return 1, default_return
    if is_iae == "FALSE" and kvs.get("deploy_product_scene") == "IAE":
        LOCAL_LOGGER.error("The product is Campus, but software package is IAE, which is not "
                           "match .")
        default_return.update({'item_result': i18_res.get('check_package_err2')})
        return 2, default_return
    if is_iae == "TRUE" and kvs.get("deploy_product_scene") != "IAE":
        LOCAL_LOGGER.error("The product is IAE, but software package is Campus, which is not "
                           "match .")
        default_return.update({'item_result': i18_res.get('check_package_err3')})
        return 3, default_return
    return 0, default_return


def execute_script(default_return, i18_res):
    """
    execute_script
    """

    # 检查EasySuite版本是否更新
    check_easysuite_result, default_return = check_easysuite_version(default_return, i18_res)
    if check_easysuite_result != 0:
        return 500, default_return

    check_result, fail_script = subprocess.getstatusoutput("sh /tmp/check_param/execute_script.sh")
    default_return_tmp = default_return
    if check_result != 0:
        if check_result == 1:
            default_return_tmp.update({'item_result': i18_res.get('execute_script_err1') +
                                                      fail_script})
        elif check_result == 2:
            default_return_tmp.update({'item_result': i18_res.get('execute_script_err2') +
                                                      fail_script})
    return check_result, default_return_tmp


def modify_second_param(kvs):
    """
    :param kvs: 用户输入的网络参数
    :return: 失败返回FAILED，成功返回SUCCESS
    """
    if_second_confirm = kvs.get('if_second_confirm')
    task_id = kvs.get('easysuite.task_id')
    product_id = kvs.get('product')
    json_base_path = os.path.join(settings.VAR_DIR, 'task_config', str(task_id), str(product_id),
                                  'website', 'data', 'upgradeconfig.json')
    with open(json_base_path, "r", encoding='utf-8') as jsonfile:
        data = json.load(jsonfile)
    if if_second_confirm == 'YES':
        data["upgradeconfig"][0]["secondphase_upgrade_dialog"] = "true"
    else:
        data["upgradeconfig"][0]["secondphase_upgrade_dialog"] = "false"
    with open(json_base_path, "w") as jsonfile:
        json.dump(data, jsonfile, indent=4, ensure_ascii=False)
