# encoding=utf-8
"""
功 能：自动获取定制升级参数配置页面
版权信息：华为技术有限公司，版本所有(C) 2019-2029
修改记录：2019-12-11 12:00 创建
"""
import logging

LOCAL_LOGGER = logging.getLogger(__name__)


def exe(upgrade_params, page_list):
    """
    功能说明:自动获取定制升级页面
    :param upgrade_params
    :param page_list
    :return 无定制直接返回page_list, 定制化失败默认返回False
    """
    page_data = page_list[0].get('pages')
    control_sets = page_data[0].get("control_sets")
    for control_set_order in control_sets:
        controls = control_set_order.get('controls')
        for control_order in controls:
            if control_order.get('id') == 'src_version':
                control_order.update({'editable': 'true', 'visible': 'true'})
            if control_order.get('id') == 'upgrade_item' \
                    and control_order.get('type') == 'upgrade_checkbox_group':
                control_order.update({"default": "id_upgrade_nce", "visible": "false"})
    LOCAL_LOGGER.info(page_list)
    LOCAL_LOGGER.info(upgrade_params)
    return page_list


def exe_upgrade_items(upgrade_params):
    """
    功能说明:自动获取定制升级参数
    :param upgrade_params
    :return upgrade_params
    """
    # 定制升级参数
    return upgrade_params
