#!/bin/bash
CUR_PATH=$(dirname $(readlink -f $0))

function execute_script()
{
    rm -rf /tmp/plandata_upgrade
    mkdir /tmp/plandata_upgrade

    if [ -f "/opt/oss/upgrade_custom_script/plandata_upgrade_script.zip" ]; then
        unzip /opt/oss/upgrade_custom_script/plandata_upgrade_script.zip -d /tmp/plandata_upgrade > /dev/null 2>&1
    fi

    find /tmp/plandata_upgrade/plandata_upgrade_*.sh  > /dev/null 2>&1

    if [ $? -eq 0 ];then
        rm -rf /tmp/plandata_upgrade/*.result
        result_arry=()
        # shellcheck disable=SC2231
        cd /tmp/plandata_upgrade
        for custScript in plandata_upgrade_*.sh
        do
            sh ${custScript} &
            result_arry[${#result_arry[*]}]=${custScript%.sh}.result
        done

        error_arry=()

        for ((i=0; i<180; i++))
        do
            for result in ${result_arry[@]}
            do
                cat $result 2>/dev/null |grep 1 >/dev/null
                if [ $? -eq 0 ];then
                    error_arry=(`echo ${error_arry[@]}` ${result%.result}.sh)
                    result_arry=(`echo ${result_arry[@]/$result/}`)
                fi
                cat $result 2>/dev/null |grep 0 >/dev/null
                if [ $? -eq 0 ];then
                    result_arry=(`echo ${result_arry[@]/$result/}`)
                fi
            done
            if [ ${#result_arry[@]} -eq 0 ];then
                break
            fi
            sleep 5
        done
        cd - > /dev/null 2>&1
        if [ ${#result_arry[@]} -ne 0 ];then
            echo "${result_arry[@]%.result}"
            return 1
        elif [ ${#error_arry[@]} -ne 0 ]; then
            echo "${error_arry[@]%.result}"
            return 2
        fi
    fi
    return 0
}

execute_script
exit $?





