#!/bin/bash

. ./arbitration_opertate_lib
. ./env.properties
. ./public.sh
env_ips=$(get_current_ips)
LOCAL_NODE_ROLE="third"
#############################################
#
#     所有仲裁节点：格式  node1,node2,node3
#
#############################################
function get_work_path()
{
    local dir=$(dirname $0)
    local ispointstart=$(echo $dir|awk -F/ '{print $1}')
    if [ "${ispointstart}" = "." ]
    then
        local dir=$(echo ${dir}|sed 's/^.//')
        workfolder="$(pwd)${dir}"
    elif [ "${ispointstart}" = ".." ]
    then
        workfolder="$(pwd)/${dir}"
    else
        workfolder="${dir}"
    fi
}

get_work_path

function init()
{
    master_omp_node_ip=$1
    master_omp_node_uname=$2
    slave_omp_node_ip=$3
    slave_omp_node_uname=$4
    master_dc_region=$5
    master_nodes_ips=$6
    slave_dc_region=$7
    slave_nodes_ips=$8
    third_node_ip=$9

    if [[ ${master_dc_region} == "" ]] && [[ ${master_nodes_ips} == "" ]] && [[ ${slave_dc_region} == ""  ]] && [[ ${slave_nodes_ips} == ""  ]] && [[ ${third_node_ip} == "" ]]
    then
        master_dc_region=`cat /opt/backup_arbitration/opt_arbitration/arbitration/conf/arbitration_conf.properties |grep master_location_name|awk -F = '{printf $2}'`
        master_nodes_ips=`cat /opt/backup_arbitration/opt_arbitration/arbitration/conf/arbitration_conf.properties |grep master_nodes_inner_ips|awk -F = '{printf $2}'`
        slave_dc_region=`cat /opt/backup_arbitration/opt_arbitration/arbitration/conf/arbitration_conf.properties |grep slave_location_name|awk -F = '{printf $2}'`
        slave_nodes_ips=`cat /opt/backup_arbitration/opt_arbitration/arbitration/conf/arbitration_conf.properties |grep slave_nodes_inner_ips|awk -F = '{printf $2}'`
        third_node_ip=`cat /opt/backup_arbitration/opt_arbitration/arbitration/conf/arbitration_conf.properties |grep third_node_inner_ip|awk -F = '{printf $2}'`
    fi

    master_nodes_ip_list=(`echo $master_nodes_ips|tr ',' ' '`)
    for node_ip in ${master_nodes_ip_list[@]}
    do
        real_node_ip=$(get_real_full_ip ${node_ip})
        if [[ $(echo "${env_ips}" | grep -iwF "${real_node_ip}") != "" ]]
        then
            LOCAL_NODE_IP="${node_ip}"
            LOCAL_NODE_ROLE="master"
            break
        fi
    done

    slave_nodes_ip_list=(`echo ${slave_nodes_ips}|tr ',' ' '`)
    for node_ip in ${slave_nodes_ip_list[@]}
    do
        real_node_ip=$(get_real_full_ip ${node_ip})
        if [[ $(echo "${env_ips}" | grep -iwF "${real_node_ip}") != "" ]]
        then
            LOCAL_NODE_IP="${node_ip}"
            LOCAL_NODE_ROLE="slave"
            break
        fi
    done

    if [ "${LOCAL_NODE_ROLE}" == "third" ]
    then
        real_node_ip=$(get_real_full_ip ${third_node_ip})
        if [[ $(echo "${env_ips}" | grep -iwF "${real_node_ip}") != "" ]]
        then
            LOCAL_NODE_IP="${third_node_ip}"
        fi
    fi

    sed -i "s/aam.mastersite=.*/aam.mastersite=${master_dc_region}/g" "${MONITOR_HOME}"/conf/aam.properties
    arbitration_log INFO "CONFIG_MONITOR" "Local node is ${LOCAL_NODE_ROLE} role."
}

function get_params()
{
    echo "es_input: master_omp_node_pwd"
    read -s -r master_omp_node_pwd
    echo "es_input: master_omp_node_ossadm_pwd"
    read -s -r master_omp_node_ossadm_pwd

    echo "es_input: slave_omp_node_pwd"
    read -s -r slave_omp_node_pwd
    echo "es_input: slave_omp_node_ossadm_pwd"
    read -s -r slave_omp_node_ossadm_pwd
}

function create_check_file()
{
    result_code=$1
    create_check_result_file ${result_code} "check_config_etcd_result.sh"
}

function init_etcd_certificate()
{
    LOCAL_NODE_IP=$1
    if [ -z ${LOCAL_NODE_IP} ]; then
        arbitration_log ERROR "CONFIG_ETCD" "missing LOCAL_NODE_IP."
        $(create_check_file 255)
        exit
    fi

    rm -rf ${ETCD_HOME}/ssl
    # 调用随机数生成随机密码，至少含有一个大写字母、小写字母、数字、特殊字符
    random_password=$(bash ${workfolder}/generate_random_pwd.sh)
    random_password=$(echo ${random_password} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')

    expect  << EOF
set timeout 30
spawn sudo -u arbiter bash ${ETCD_HOME}/script/init-cert.sh ${LOCAL_NODE_IP}
    expect {
        "please input random password:" {send -- "${random_password}\r"}
    }

expect eof
EOF

    # 检查是否生成证书
    if [ -f "${ETCD_HOME}/ssl/server.cer" ]
    then
        arbitration_log INFO "CONFIG_ETCD" "Generate server certificate successfully."
    else
        arbitration_log ERROR "CONFIG_ETCD" "Generate server certificate failed."
        try_again=$2
        if [ -z $try_again ]; then
            sleep 1
            init_etcd_certificate ${LOCAL_NODE_IP} "again"
        else
            $(create_check_file 255)
            exit
        fi
    fi
}

function etcd_config()
{
    rm -f /opt/arbitration_file/check_config_etcd_result.sh

    arbitration_log INFO "CONFIG_ETCD" "Start config etcd on node:${LOCAL_NODE_IP}."
    if [ ! -d "${ARBITRATION_LOG}/etcd" ];then
        mkdir -p "${ARBITRATION_LOG}/etcd"
        chmod 750 "${ARBITRATION_LOG}/etcd"
    fi
    init_etcd_certificate ${LOCAL_NODE_IP}

    sed -i "s#<property name=\"LOG_HOME\">.*</property>#<property name=\"LOG_HOME\">${ETCD_LOG}</property>#g" "${ETCD_HOME}/conf/log4j2.xml"
}



function config_monitor()
{
    arbitration_log INFO "CONFIG_MONITOR" "Start config arbitration-monitor."
    result=""

    if [ ! -d "${ARBITRATION_LOG}/monitor" ];then
        mkdir -p "${ARBITRATION_LOG}/monitor"
        chmod 750 "${ARBITRATION_LOG}/monitor"
    fi
    if [[ ${LOCAL_NODE_ROLE} == "master" ]]
    then
        ${COMMON_HOME}/foss/python/bin/python ${MONITOR_HOME}/script/setup.pyc --role "${LOCAL_NODE_ROLE}" --localdcserial ${master_dc_region} --localip ${LOCAL_NODE_IP} --localetcdservers ${master_nodes_ips} --remotedcserial ${slave_dc_region} --remoteetcdservers ${slave_nodes_ips} --publicetcdservers ${third_node_ip} --custom
        result=$?
    elif [[ ${LOCAL_NODE_ROLE} == "slave" ]]
    then
        ${COMMON_HOME}/foss/python/bin/python ${MONITOR_HOME}/script/setup.pyc --role "${LOCAL_NODE_ROLE}" --localdcserial ${slave_dc_region} --localip ${LOCAL_NODE_IP} --localetcdservers ${slave_nodes_ips} --remotedcserial ${master_dc_region} --remoteetcdservers ${master_nodes_ips} --publicetcdservers ${third_node_ip} --custom
        result=$?
    else
        ${COMMON_HOME}/foss/python/bin/python ${MONITOR_HOME}/script/setup.pyc --role "${LOCAL_NODE_ROLE}" --localdcserial "public" --localip ${LOCAL_NODE_IP} --localetcdservers ${third_node_ip} --remotedcserial "not_public" --remoteetcdservers "${master_nodes_ips},${slave_nodes_ips}" --publicetcdservers ${third_node_ip} --custom
        result=$?
    fi

    if [[ $result == "0" ]]
    then
        arbitration_log INFO "CONFIG_MONITOR" "Config arbitration-monitor successfully."
    else
        arbitration_log INFO "CONFIG_MONITOR" "Config arbitration-monitor failed."
        $(create_check_file 255)
        exit
    fi
}

function init_monitor_certificate()
{
    arbitration_log INFO "CONFIG_MONITOR" "Start config arbitration-monitor certificate."
    for i in {1..3}
    do
        sudo -u arbiter bash ${MONITOR_HOME}/script/init-cert.sh
        config_certificate_result=$?
        if [ ${config_certificate_result} -eq 0 ]
        then
            break
        fi
        arbitration_log INFO "CONFIG_MONITOR" "retry to config monitor certificate"
        sleep 1
    done

    if [ ${config_certificate_result} -ne 0 ]
    then
        arbitration_log ERROR "CONFIG_MONITOR" "Config monitor certificate failed."
        $(create_check_file 255)
        exit
    else
        arbitration_log INFO "CONFIG_MONITOR" "Config arbitration-monitor certificate success."
    fi
}

function remote_modify_ha()
{
    exec_file="${workfolder}/remote_modify_ha.sh"

    expect  << EOF >/dev/null 2>&1
set timeout 30
spawn bash ${exec_file} ${omp_node_uname} "etcd_pwd_of_ks"
    expect {
        "please input login password:" {send -- "${omp_node_pwd}\r"}
    }


    expect {
        "please input ossadm password:" {send -- "${omp_node_ossadm_pwd}\r"}
    }

    expect {
        "please input random password:" {send -- "${random_password}\r"}
    }

    expect {
        "*modify properties failed*" { exit 255 }
        "*modify properties successfully*" { exit 100 }
    }

expect eof

catch wait result
exit [lindex $result 3]

EOF

    result=$?

    if [ ${result} -eq 100 ]
    then
        arbitration_log INFO "CONFIG_ETCD" "Modify ha.properties successfully."
    else
        arbitration_log ERROR "CONFIG_ETCD" "Failed to modify the ha.properties file of node ${omp_node_ip}."
        $(create_check_file 255)
        exit
    fi
}

function start_etcd_service()
{
    sudo -u arbiter bash "${ETCD_HOME}"/script/service.sh restart
    if [ $? -eq 0 ]
    then
        arbitration_log INFO "CONFIG_ETCD" "start etcd successfully."
    else
        arbitration_log INFO "CONFIG_ETCD" "start etcd failed."
        $(create_check_file 255)
        exit
    fi
}

$(create_check_file 1)
init $@
# 创建ETCD目录，已经生成ETCD证书
etcd_config
# 修改Monitor配置文件
config_monitor
# 生成Monitor证书
init_monitor_certificate
# 启动ETCD进程
start_etcd_service

# 获取输入参数
get_params
# 当前节点为master的第一个common_service节点时，执行以下代码刷新主站点所有OMP的ha.properties
# 只在master的第一个common_service节点执行一次，其他节点不执行
if [ "${LOCAL_NODE_ROLE}" == "master" -a "${LOCAL_NODE_IP}" == "${master_nodes_ip_list[0]}" ]
then
    omp_node_ip=${master_omp_node_ip}
    omp_node_uname=${master_omp_node_uname}

    # 获取主站点密码，转义特殊字符
    omp_node_pwd=$(echo ${master_omp_node_pwd} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')
    omp_node_ossadm_pwd=$(echo ${master_omp_node_ossadm_pwd} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')
    # 本地调用远程OMP的脚本
    remote_modify_ha
elif [ "${LOCAL_NODE_ROLE}" == "slave" -a "${LOCAL_NODE_IP}" == "${slave_nodes_ip_list[0]}" ]
then
    omp_node_ip=${slave_omp_node_ip}
    omp_node_uname=${slave_omp_node_uname}

    # 获取备站点密码，转义特殊字符
    omp_node_pwd=$(echo ${slave_omp_node_pwd} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')
    omp_node_ossadm_pwd=$(echo ${slave_omp_node_ossadm_pwd} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')
    # 本地调用远程OMP的脚本
    remote_modify_ha
fi

$(create_check_file 100)
