#!/bin/bash
. ./arbitration_opertate_lib
. ./public.sh
. ./env.properties

function create_check_file()
{
    result_code=$1
    create_check_result_file ${result_code} "check_config_monitor_result.sh"
}

function start_service()
{
    sudo -u arbiter bash "${MONITOR_HOME}"/script/service.sh restart
    if [ $? -eq 0 ]
    then
        arbitration_log INFO "CONFIG_MONITOR" "start monitor successfully."
        $(create_check_file 100)
    else
        arbitration_log ERROR "CONFIG_MONITOR" "start monitor failed."
        $(create_check_file 255)
        exit
    fi
}

function main()
{
    rm -f /opt/arbitration_file/check_config_monitor_result.sh
    start_service
}

main $@