#! /bin/bash
#########################################################
# Copyright © Huawei Technologies Co., Ltd. 2020-2020. All rights reserved.
# File name: arbitration_generate_ca.sh
# Description: 生成ca证书并修改OMP节点下的ha.properties文件
###########################################################
function get_work_path()
{
    local dir=$(dirname $0)
    local ispointstart=$(echo $dir|awk -F/ '{print $1}')
    if [ "${ispointstart}" = "." ]
    then
        local dir=$(echo ${dir}|sed 's/^.//')
        workfolder="$(pwd)${dir}"
    elif [ "${ispointstart}" = ".." ]
    then
        workfolder="$(pwd)/${dir}"
    else
        workfolder="${dir}"
    fi
}

function create_check_file()
{
    result_code=$1
    create_check_result_file ${result_code} "check_generate_ca_result.sh"
}

function get_params()
{
    master_omp_node_ip=$1
    master_omp_node_uname=$2
    echo "es_input: master_omp_node_pwd"
    read -s -r master_omp_node_pwd
    echo "es_input: master_omp_node_ossadm_pwd"
    read -s -r master_omp_node_ossadm_pwd
    
    slave_omp_node_ip=$3
    slave_omp_node_uname=$4
    echo "es_input: slave_omp_node_pwd"
    read -s -r slave_omp_node_pwd
    echo "es_input: slave_omp_node_ossadm_pwd"
    read -s -r slave_omp_node_ossadm_pwd

    # 获取备NCE的common_server节点间通信IP
    slave_inner_comm_ip=$5
    echo "es_input: node_3_root_pwd"
    read -s -r slave_comm_root_pwd


    # 转义特殊字符
    master_omp_node_pwd=$(echo ${master_omp_node_pwd} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')
    master_omp_node_ossadm_pwd=$(echo ${master_omp_node_ossadm_pwd} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')

    slave_omp_node_pwd=$(echo ${slave_omp_node_pwd} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')
    slave_omp_node_ossadm_pwd=$(echo ${slave_omp_node_ossadm_pwd} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')

    slave_comm_root_pwd=$(echo ${slave_comm_root_pwd} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')
}

function generate_ca()
{
    # 生成CA证书前，如果存在先删除目录
    [ -d "${ETCD_HOME}/ca" ] && rm -rf "${ETCD_HOME}/ca"

    rm -f /opt/arbitration_file/check_generate_ca_result.sh

    arbitration_log INFO "GENERATE_CA" "Start generate ca."
    
    # 调用随机数生成随机密码，至少含有一个大写字母、小写字母、数字、特殊字符
    random_password=$(bash ${workfolder}/generate_random_pwd.sh)
    random_password=$(echo ${random_password} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')
    
    expect  << EOF
set timeout 30
spawn sudo -u arbiter bash ${ETCD_HOME}/script/init-ca.sh
expect {
        "please input random password:" {send -- "${random_password}\r"}
    }

expect eof

EOF

    # 检查是否生成证书
    if [[ -f "${ETCD_HOME}/ca/ca.cer" && -f "${ETCD_HOME}/ca/ca.csr" && -f "${ETCD_HOME}/ca/ca_key.pem" && -f "${ETCD_HOME}/ca/manifest.json" ]]
    then
        arbitration_log INFO "GENERATE_CA" "Generate ca successfully."
    else
        arbitration_log ERROR "GENERATE_CA" "Generate ca failed."
        return 1
    fi

    return 0
}

function remote_modify_ha()
{
    exec_file="${workfolder}/remote_modify_ha.sh"
    
    # 修改主站点omp的/opt/oss/share/manager/DRService/configuration/ha.properties 的 etcd_pwd_of_ts 字段密文
    expect  << EOF >/dev/null 2>&1
set timeout 30
spawn bash ${exec_file} ${master_omp_node_uname} "etcd_pwd_of_ts"
    expect {
        "please input login password:" {send -- "${master_omp_node_pwd}\r"}
    }
    
        
    expect {
        "please input ossadm password:" {send -- "${master_omp_node_ossadm_pwd}\r"}
    }
    
    expect {
        "please input random password:" {send -- "${random_password}\r"}
    }
    
    expect {
        "*modify properties failed*" { exit 255 }
        "*modify properties successfully*" { exit 100 }
    }

expect timeout { exit 1 }
expect eof

catch wait result
exit [lindex $result 3]

EOF
    result_master=$?
    sleep 1

    # 如果已有互信先删除，处理对端重装互信失效的情况
    [ -f /root/.ssh/known_hosts ] && sed -i "/^${slave_inner_comm_ip} /d" /root/.ssh/known_hosts

    # 修改备站点omp的/opt/oss/share/manager/DRService/configuration/ha.properties 的 etcd_pwd_of_ts 字段密文
    expect  << EOF >/dev/null 2>&1
set timeout 60
spawn ssh root@${slave_inner_comm_ip}
expect {
    "*yes/no*" {send "yes\r";exp_continue}
    "*assword:" {send -- "${slave_comm_root_pwd}\r"}
}

expect {
    "*#" {
        send "bash ${exec_file} ${slave_omp_node_uname} \"etcd_pwd_of_ts\"\r"
        expect {
            "please input login password:" {send -- "${slave_omp_node_pwd}\r"}
        }

        expect {
            "please input ossadm password:" {send -- "${slave_omp_node_ossadm_pwd}\r"}
        }

        expect {
            "please input random password:" {send -- "${random_password}\r"}
        }

        expect {
            "*modify properties failed*" { exit 255 }
            "*modify properties successfully*" { exit 100 }
        }

    }
}

expect timeout { exit 1 }
expect eof

catch wait result
exit [lindex $result 3]

EOF

    result_slave=$?
}

function main()
{
    . ./arbitration_opertate_lib
    . ./env.properties
    . ./public.sh
    source /opt/arbitration_file/config/installEnv.properties
    if [ "${GENERATE_CERT}" == "false" ]
    then
        $(create_check_file 100)
        return 0
    fi

    get_work_path

    # 获取参数
    get_params "$@"

    # 生成CA
    for i in {1..3} ; do
        arbitration_log INFO "GENERATE_CA" "generate ca by ${i}"
        generate_ca
        if [ $? -eq 0 ]; then
            break
        fi

        if [ $i -eq 3 ]
        then
            $(create_check_file 255)
            exit
        fi
    done

    # 刷新ha.properties
    remote_modify_ha
    if [ ${result_master} -eq 100 ] && [ ${result_slave} -eq 100 ]
    then
        arbitration_log INFO "GENERATE_CA" "Modify ha.properties successfully."
    else
        # 重试一次
        remote_modify_ha
        if [ ${result_master} -ne 100 ] || [ ${result_slave} -ne 100 ]
        then
            if [ ${result_master} -ne 100 ]
            then
                arbitration_log ERROR "GENERATE_CA" "Modify master ha.properties failed."
            fi
            if [ ${result_slave} -ne 100 ]
            then
                arbitration_log ERROR "GENERATE_CA" "Modify slave ha.properties failed."
            fi

            $(create_check_file 255)
            exit
        fi
    fi

    $(create_check_file 100)
}

main "$@"
