#! /bin/bash
#########################################################
# Copyright © Huawei Technologies Co., Ltd. 2020-2020. All rights reserved.
# File name: arbitration_sync_ca.sh
# Description: 同步CA证书到其他仲裁节点
###########################################################
function get_work_path()
{
    local dir=$(dirname $0)
    local ispointstart=$(echo $dir|awk -F/ '{print $1}')
    if [ "${ispointstart}" = "." ]
    then
        local dir=$(echo ${dir}|sed 's/^.//')
        workfolder="$(pwd)${dir}"
    elif [ "${ispointstart}" = ".." ]
    then
        workfolder="$(pwd)/${dir}"
    else
        workfolder="${dir}"
    fi
}

function create_check_file()
{
    result_code=$1
    create_check_result_file ${result_code} "check_sync_ca_result.sh"
}

function get_params()
{
    # 获取ca证书所在节点IP
    node_1_ip=$1
    # 获取ca证书所在节点用户名密码
    echo "es_input: os_user_root"
    read -s -r os_user_root
    echo "es_input: node_1_root_pwd"
    read -s -r node_1_root_pwd

    # 特殊字符转义
    node_1_root_pwd=$(echo ${node_1_root_pwd} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')
}

function remote_copy_file()
{
    
    node_ip=$1
    node_root_user=$2
    node_root_pwd=$3
    copy_file_name=$4

    # 如果已有互信先删除，处理对端重装互信失效的情况
    [ -f /root/.ssh/known_hosts ] && sed -i "/^${node_ip} /d" /root/.ssh/known_hosts

    target_file="${ETCD_HOME}/ca/${copy_file_name}"

    # 转换IPV6格式
    echo ${node_ip} | grep ":" >/dev/null 2>&1
    if [ $? -eq 0 ]
    then
      node_ip="\["${node_ip}"\]"
    fi

    # 交互式scp拷贝
    expect  << EOF >/dev/null 2>&1
set timeout 30
spawn scp ${node_root_user}@${node_ip}:/opt/arbitration-etcd/ca/${copy_file_name} ${target_file}
    expect {
        "*yes/no*" {send "yes\r";exp_continue}
        "*assword:" {send -- "${node_root_pwd}\r"}
    }

expect eof
EOF
    
    # 刷属组和权限
    if [ -f "${target_file}" ]
    then
        chown arbiter:ArbiterGroup ${target_file}
        chmod 600 ${target_file}
        arbitration_log INFO "SYNC_CA" "Copy file ${target_file} from ${node_ip} successfully."
    else
        arbitration_log ERROR "SYNC_CA" "Copy file ${target_file} from ${node_ip} failed."
        return 1
    fi
    return 0
}

function main()
{
    . ./arbitration_opertate_lib
    . ./env.properties
    . ./public.sh
    source /opt/arbitration_file/config/installEnv.properties
    if [ "${GENERATE_CERT}" == "false" ]
    then
        $(create_check_file 100)
        return 0
    fi

    get_work_path

    # 获取参数
    get_params "$@"

    rm -f /opt/arbitration_file/check_sync_ca_result.sh

    arbitration_log INFO "SYNC_CA" "Start to copy all the target file."

    # 需要拷贝的文件
    ca_cer_name=ca.cer
    ca_key_name=ca_key.pem
    manifest_name=manifest.json

    # 创建文件列表
    copy_file_array=("${ca_cer_name}" "${ca_key_name}" "${manifest_name}")

    # 创建CA目录
    [ -d "${ETCD_HOME}/ca" ] && rm -rf "${ETCD_HOME}/ca"
    mkdir -p "${ETCD_HOME}/ca"
    chown arbiter:ArbiterGroup "${ETCD_HOME}/ca"
    chmod 700 "${ETCD_HOME}/ca"
    # 依次拷贝文件
    for copy_file in ${copy_file_array[@]}
    do
        remote_copy_file "${node_1_ip}" "${os_user_root}" "${node_1_root_pwd}" "${copy_file}"
        if [ $? -ne 0 ]
        then
            # 重试一次
            remote_copy_file "${node_1_ip}" "${os_user_root}" "${node_1_root_pwd}" "${copy_file}"
            if [ $? -ne 0 ]
            then
                $(create_check_file 255)
                exit
            fi
        fi
    done

    arbitration_log INFO "SYNC_CA" "Copy all the file successfully."
    $(create_check_file 100)
}

main "$@"

