#!/bin/bash

. ./arbitration_opertate_lib

function init()
{
    echo "es_input: os_pwd_sopuser"
    read -rs OS_PWD_SOPUSER
    echo "es_input: product_pwd_ossadm"
    read -rs OS_PWD_OSSADM
    echo "es_input: install_type"
    read -rs INSTALL_TYPE
    echo ${INSTALL_TYPE}
    SUCCESS_RESULT=0
    ERROR_RESULT=1
}

function os_relate_operate() {
    if [ ${INSTALL_TYPE} == "increment_install" ];then
        increment_install
    else
        full_install
    fi
    return $?
}


function full_install() {
    local fun_name="FULL_INSTALL"
    arbitration_log INFO "${fun_name}" "This node is third node."

    # 先删除账号
    echo "delete user sopuser"
    id "sopuser" >/dev/null 2>&1
    if [ $? -eq 0 ]
    then
        delete_user "sopuser" || return ${ERROR_RESULT}
    fi

    # 欧方安装连带创建ossadm用户
    install_os_mediation || return ${ERROR_RESULT}

    # 创建sopuser用户
    create_sopuser || return ${ERROR_RESULT}

    # 安全加固
    run_sek || return ${ERROR_RESULT}
}

function increment_install() {
    local fun_name="INCREMENT_INSTALL"
    arbitration_log INFO "${fun_name}" "This node is third node."

    # 解压获取当前osconfig版本号
    if [ -f /etc/os-release ] && [ "$(grep SUSE /etc/os-release)" ]; then
        echo "[$(date)] current os type is SuSE"
        os_config_pkg="$(ls /opt/install/os_mediation/osconfig-*.zip | grep -vi euler)"
    elif [ -f /etc/os-release ] && [ "$(grep EulerOS /etc/os-release)" ]; then
        echo "[$(date)] current os type is Euler"
        os_config_pkg="$(ls /opt/install/os_mediation/osconfig-*.zip | grep -i euler)"
    else
        echo "[$(date)] can not support OS type, only support euler or suse."
        return ${ERROR_RESULT}
    fi

    unzip -o ${os_config_pkg} -d /opt/install/os_mediation/osconfig >/dev/null 2>&1
    local current_osconfig_version="$(sed '/^release_version=/!d;s/.*=//' /opt/install/os_mediation/osconfig/package/release_version.properties)"
    local old_osconfig_version="$(sed '/^release_version=/!d;s/.*=//' /usr/local/osconfig/os/bin/release_version.properties)"
    echo "current_osconfig_version:"${current_osconfig_version}
    echo "old_osconfig_version:"${old_osconfig_version}

    # 如版本号低，则重装欧方
    if [ -z "${old_osconfig_version}" ] || version_gt ${current_osconfig_version} ${old_osconfig_version};then
        echo "current_osconfig_version:${current_osconfig_version} is greater than old_osconfig_version:${old_osconfig_version}"
        # 欧方安装连带创建ossadm用户
        install_os_mediation || return ${ERROR_RESULT}

        # 安全加固
        run_sek || return ${ERROR_RESULT}
    fi

    id "sopuser" >/dev/null 2>&1
    if [ $? -eq 0 ]
    then
        arbitration_log INFO "${fun_name}" "delete sopuser."
        delete_user "sopuser" || return ${ERROR_RESULT}
        arbitration_log INFO "${fun_name}" "delete sopuser success."
    fi

    arbitration_log INFO "${fun_name}" "create sopuser."
    create_sopuser || return ${ERROR_RESULT}
    arbitration_log INFO "${fun_name}" "create sopuser success."

    change_ossadm_group
}

function version_gt() {
    test "$(echo "$@" | tr " " "\n" | sort -V | head -n 1)" != "$1";
}

function run_sek()
{
    local fun_name="RUN_SEK"
    arbitration_log INFO "${fun_name}" "This node is third node."

    # 安全加固
    bash /opt/SEK/RunSEK.sh >/dev/null 2>&1
    if [ $? -ne 0 ];then
        echo "Run SEK failed"
        arbitration_log ERROR "${fun_name}" "Run SEK failed"
        return ${ERROR_RESULT}
    fi
    arbitration_log INFO "${fun_name}" "Run SEK success"

    bash /opt/SEK/cmd/SetEnv.sh >/dev/null 2>&1
    if [ $? -ne 0 ];then
        echo "Set Env failed"
        arbitration_log ERROR "${fun_name}" "Set Env failed"
        return ${ERROR_RESULT}
    fi

    arbitration_log INFO "${fun_name}" "Third node reinforce success."
}

function create_check_file()
{
    result_code=$1
    create_check_result_file ${result_code} "check_os_mediation_result.sh"
}

function delete_user()
{
    local fun_name="DELETE_USER"
    local user=$1
    for((i=1;i<=3;i++));
    do
        killall -u ${user} >/dev/null 2>&1 ;
    done
    userdel -rf ${user} || {  echo "${fun_name}" "Failed to delete the ${user}."; return ${ERROR_RESULT};}
    sed -i "/^${user}/d" /etc/security/opasswd
    echo "${fun_name}" "The ${user} information is cleared."
}


function create_sopuser()
{
    # 强制删除username文件，防止注入密码失败
    rm -f /usr/local/os_tool/etc/username.properties
    local fun_name="CREATE_SOPUSER"
    local user="sopuser"
    # 注入用户密码
    echo -e "${OS_PWD_SOPUSER}" | su - ossadm -c "bash /usr/local/osconfig/os/bin/injectpvalue.sh ${user}" >/dev/null 2>&1
    if [ $? -ne 0 ];then
        echo "user:${user} injectp failed"
        arbitration_log ERROR "${fun_name}" "user:${user} injectp failed"
        return ${ERROR_RESULT}
    fi
    echo "user:${user} injectp success"

    # 创建用户
    su - ossadm -c "bash /usr/local/osconfig/os/bin/addosuser.sh ${user}" >/dev/null 2>&1
    if [ $? -ne 0 ];then
        echo "user:${user} create failed"
        arbitration_log ERROR "${fun_name}" "user:${user} create failed"
        return ${ERROR_RESULT}
    fi
    echo "user:${user} create success"
}


function install_os_mediation()
{
    if [ -z "${OS_PWD_OSSADM}" ];then
        echo "OS_PWD_OSSADM is empty"
        bash /opt/install/os_mediation/install.sh -increment increment_install
    else
        { echo -e "${OS_PWD_OSSADM}";} | bash /opt/install/os_mediation/install.sh
    fi
    # 重装欧方连带创建ossadm用户
    { echo -e "${OS_PWD_OSSADM}";} | bash /opt/install/os_mediation/install.sh -increment increment_install
    if [ $? -ne 0 ];then
        echo "os_mediation install failed"
        arbitration_log ERROR "${fun_name}" "os_mediation install failed"
        return ${ERROR_RESULT}
    fi
}

#################################################
#
# 修改ossadm用户组, 低版本升级时将ossadm加入sopgroup用户组
#
#################################################
function change_ossadm_group() {
  id "ossadm" | grep "sopgroup" >/dev/null 2>&1
  if [ $? -eq 0 ]; then
    arbitration_log INFO "ARBITRATION_OS_MEDIATION" "ossadm already in sopgroup."
    return
  fi

  su - ossadm -c "bash /usr/local/osconfig/os/bin/changeusergroup.sh -type upgrade" >/dev/null 2>&1
  if [ $? -eq 0 ]; then
      arbitration_log INFO "ARBITRATION_OS_MEDIATION" "change ossadm group success."
  fi
}

function main()
{
    init
    os_relate_operate
}

main
if [ $? -eq 0 ];then
    $(create_check_file 100)
else
    $(create_check_file 255)
fi