#!/bin/bash
echo "SMPAgentService script execut start"

function checkSpecialChar()
{
	line="$1"
    if [[ "$line" =~ "\$" ]] || [[ "$line" =~ "\`" ]] || [[ "$line" =~ "|" ]] || [[ "$line" =~ " " ]] || [[ "$line" =~ ";" ]] || [[ "$line" =~ "[" ]] || [[ "$line" =~ "{" ]] || [[ "$line" =~ "=" ]] || [[ "$line" =~ "&" ]] || [[ "$line" =~ "+" ]] || [[ "$line" =~ "]" ]] || [[ "$line" =~ "}" ]] || [[ "$line" =~ "%" ]] || [[ "$line" =~ "<" ]] || [[ "$line" =~ ">" ]]
    then
		return 1
    fi

	return 0
}

ls /etc/sysconfig/network/ifroute-* >/dev/null 2>&1
if [ $? -eq 0 ]
then
	for file in `ls /etc/sysconfig/network/ifroute-*`; do
		checkSpecialChar "$file"
		if [ $? == 1 ]
		then
			continue
		fi
		if [ -f "${file}" ]; then
			result=`cat "${file}" |awk -F ' ' '{print $2}'`
			if [ -n  "$result" ]
			then
				echo "$result"
			fi
		fi
	done
fi

ls /etc/sysconfig/network/ifcfg-* >/dev/null 2>&1
if [ $? -eq 0 ]
then
	for file in `ls /etc/sysconfig/network/ifcfg-*`; do
		checkSpecialChar "$file"
		if [ $? == 1 ]
		then
			continue
		fi
		if [ -f "${file}" ]; then
			result=`cat "${file}" |grep GATEWAY |awk -F '=' '{print $2}'`
			if [ -n  "$result" ]
			then
				echo "$result"
			fi
		fi
	done
fi


echo "SMPAgentService script execut end"