#!/bin/bash
#########################################################
# Copyright © Huawei Technologies Co., Ltd. 2020-2020. All rights reserved.
# File name: remote_modify_ha.sh
# Description: 调用远程OMP上的脚本刷新ha.properties
###########################################################
function get_params()
{
    login_user_name=$1
    target_field=$2
    read -s -p "please input login password:" -r login_user_pwd
    read -s -p "please input ossadm password:" -r ossadm_user_pwd
    read -s -p "please input random password:" -r random_pwd

    # 转义特殊字符
    login_user_pwd=$(echo ${login_user_pwd} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')
    ossadm_user_pwd=$(echo ${ossadm_user_pwd} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')
    random_pwd=$(echo ${random_pwd} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')
}

function get_omp_maintaince_ip()
{
    arbitration_log INFO "REMOTE_MODIFY_HA" "Start to get the OMP maintenance IP address."
    omp_maintaince_ip=$(su - ossadm -c ". /opt/oss/manager/bin/engr_profile.sh;ipmc_adm -cmd statusapp -app DRService -tenant manager -nodeip global |grep -w 'DRService' | sed -n '1p'| awk '{print \$6}'")
    arbitration_log INFO "REMOTE_MODIFY_HA" "Success to get the OMP maintenance IP address is ${omp_maintaince_ip}."
    echo ${omp_maintaince_ip}
}

# 登录OMP节点，执行OMP上预置的刷新ha.properties的脚本modify_ha.sh 
function remote_exec()
{
    ${EXPECT} << ENF >/dev/null 2>&1
set timeout 30
spawn ssh ${login_user_name}@${omp_ip_address} 
expect {
    "*yes/no*" {send "yes\r";exp_continue}
    "*assword:" {send -- "${login_user_pwd}\r"}
}

expect {
    "*${login_user_name}@*" {
                            send "su - ossadm\r"
                            expect {
                                "*yes/no*" {send "yes\r";exp_continue}
                                "*assword:" {send -- "${ossadm_user_pwd}\r"}
                                "*ossadm@*" {send "\r"}
                            }
    
                            expect {
                                "*ossadm@*" {
                                            send "bash /opt/oss/manager/apps/DRService/shscript/modify_ha.sh ${target_field}\r"
                                            expect {
                                                    "please input random password:" {send -- "${random_pwd}\r"}
                                                   }
                                            expect {
                                                "*modify properties failed*" { exit 255 }
                                                "*modify properties successfully*" { exit 100 }
                                                }
                                            }
                            }
                            
                            expect {
                                "*ossadm@*" {send "exit\r"}
                            }
    
    }
}

expect {
    "*${login_user_name}@*" {send "exit\r"}
}

expect timeout { exit 1 }
expect eof

catch wait result
exit [lindex $result 3]

ENF

expect_result=$?
arbitration_log INFO "REMOTE_MODIFY_HA" "remote execute to [${omp_ip_address}] result: ${expect_result}"
return $expect_result
}

# 本地OMP节点，执行OMP上预置的刷新ha.properties的脚本modify_ha.sh
function local_exec()
{
    ${EXPECT} << ENF >/dev/null 2>&1
set timeout 30
spawn su - ossadm
expect {
    "*ossadm@*" {
        send "bash /opt/oss/manager/apps/DRService/shscript/modify_ha.sh ${target_field}\r"
        expect {
            "please input random password:" {send -- "${random_pwd}\r"}
        }
        expect {
            "*modify properties failed*" { exit 255 }
            "*modify properties successfully*" { exit 100 }
        }
    }
}
expect {
    "*ossadm@*" {send "exit\r"}
}

expect timeout { exit 1 }
expect eof

catch wait result
exit [lindex $result 3]
ENF
    return $?
}

function omp_exec() {
    ip addr | grep -w ${omp_ip_address} >/dev/null 2>&1
    if [ $? -eq 0 ]
    then
        arbitration_log INFO "REMOTE_MODIFY_HA" "omp exec on local."
        local_exec
    else
        arbitration_log INFO "REMOTE_MODIFY_HA" "omp exec on remote."
        remote_exec
    fi
}

function main()
{
    cd /opt/arbitration_file;. ./arbitration_opertate_lib
    cd /opt/arbitration_file;. ./env.properties
    EXPECT=expect

    # 获取参数
    get_params "$@"

    omp_ip_address=$(get_omp_maintaince_ip)
    if [ -z "${omp_ip_address}" ]
    then
        arbitration_log ERROR "REMOTE_MODIFY_HA" "Failed to get the master OMP maintenance IP address."
        echo "modify properties failed"
    fi

    # 调用远程脚本修改
    omp_exec
    if [ $? -ne 100 ]
    then
        # 重试一次
        omp_exec
        if [ $? -ne 100 ]
        then
            arbitration_log ERROR "REMOTE_MODIFY_HA" "modify properties failed."
            echo "modify properties failed"
        fi
    else
        arbitration_log INFO "REMOTE_MODIFY_HA" "modify properties successfully."
        echo "modify properties successfully"
    fi
}

main "$@"




