#! /bin/bash

. ./arbitration_opertate_lib
. ./env.properties
. ./public.sh
env_ips=$(get_current_ips)
master_location="$1"
slave_location="$2"
master_node_ips="$3"
slave_node_ips="$4"

if [[ ${master_location} == "" ]] && [[ ${slave_location} == "" ]] && [[ ${master_node_ips} == "" ]] && [[ ${slave_node_ips} == "" ]]
then
    master_location=`cat /opt/backup_arbitration/opt_arbitration/arbitration/conf/arbitration_conf.properties |grep master_location_name|awk -F = '{printf $2}'`
    slave_location=`cat /opt/backup_arbitration/opt_arbitration/arbitration/conf/arbitration_conf.properties |grep slave_location_name|awk -F = '{printf $2}'`
    master_node_ips=`cat /opt/backup_arbitration/opt_arbitration/arbitration/conf/arbitration_conf.properties |grep master_nodes_inner_ips|awk -F = '{printf $2}'`
    slave_node_ips=`cat /opt/backup_arbitration/opt_arbitration/arbitration/conf/arbitration_conf.properties |grep slave_nodes_inner_ips|awk -F = '{printf $2}'`
fi

#记录结果
function create_check_file()
{
    result_code=$1
    create_check_result_file ${result_code} "check_allnodes_result.sh"
}

function set_aamonitor_version() {
  aamVersion_key="/monitor/conf/aamVersion"
  aamVersion_value="v1"
  arbitration_log INFO "SET_ALL_LOCATION" "Start set aamVersion key:${aamVersion_key}, value: ${aamVersion_value}."
  sudo -u arbiter bash ${MONITOR_HOME}/script/etcd-client.sh --set ${aamVersion_key} ${aamVersion_value}
  if [[ $? != "0" ]]
  then
      arbitration_log ERROR "SET_ALL_LOCATION" "Set aamonitor version failed."
      $(create_check_file 255)
      exit 1
  fi
}

function set_allnodes_location()
{   
    arbitration_log INFO "SET_ALL_LOCATION" "Start set primary location, master_location_name:${master_location} slave_location:${slave_location}."
    
    #配置优先站点时，key值为站点名称字符串较小的在前
    if [[ "${master_location}" < "${slave_location}" ]]
    then
        open_conf="open_${master_location}_${slave_location}"
        open_ips_conf_1="1_open_ips_${master_location}_${slave_location}"
        open_ips_conf_2="2_open_ips_${master_location}_${slave_location}"
        close_ips_conf_1="1_close_ips_${master_location}_${slave_location}"
        close_ips_conf_2="2_close_ips_${master_location}_${slave_location}"
    else
        open_conf="open_${slave_location}_${master_location}"
        open_ips_conf_1="1_open_ips_${slave_location}_${master_location}"
        open_ips_conf_2="2_open_ips_${slave_location}_${master_location}"
        close_ips_conf_1="1_close_ips_${slave_location}_${master_location}"
        close_ips_conf_2="2_close_ips_${slave_location}_${master_location}"
    fi
    
    ipaddress=$(ip addr | awk '/^[0-9]+: / {}; /inet.*global/ {print gensub(/(.*)\/(.*)/, "\\1", "g", $2)}')
    ipaddr=""
    for node in ${ipaddress[@]}
    do
        if [[ ${ipaddr} == "" ]]
        then
            ipaddr=${node}
        else
            ipaddr=${ipaddr}","${node}
        fi
    done
    
    isMaster="false"
    Mastercount=0
    master_node_ips_list=($(echo ${master_node_ips}|tr ',' ' '))
    master_node_ips_list_length=${#master_node_ips_list[@]}
    for node_ip in ${master_node_ips_list[@]}
    do
        Mastercount=$(($Mastercount+1))
        real_node_ip=$(get_real_full_ip ${node_ip})
        if [[ $(echo "${env_ips}" | grep -iwF "${real_node_ip}") != "" ]]
        then
            isMaster="true"
            break
        fi
    done

    isSlaver="false"
    Slavercount=0
    slave_node_ips_list=(`echo $slave_node_ips|tr ',' ' '`)
	slave_node_ips_list_length=${#slave_node_ips_list[@]}
    for node_ip in ${slave_node_ips_list[@]}
    do
        Slavercount=$(($Slavercount+1))
        real_node_ip=$(get_real_full_ip ${node_ip})
        if [[ $(echo "${env_ips}" | grep -iwF "${real_node_ip}") != "" ]]
        then
            isSlaver="true"
            break
        fi
    done
    
    
    if [[ ${isMaster} == "true" ]]
    then
        if [[ ${Mastercount} -eq 1 ]]
        then
            sudo -u arbiter bash ${MONITOR_HOME}/script/etcd-client.sh --set /monitor/conf/${open_ips_conf_1} ${ipaddr}
            if [[ $? != "0" ]]
            then
                arbitration_log ERROR "SET_ALL_LOCATION" "Set primary location ip failed."
                $(create_check_file 255)
                exit 1
            fi
			if [[ ${master_node_ips_list_length} -eq 1 ]]
			then
				sudo -u arbiter bash ${MONITOR_HOME}/script/etcd-client.sh --set /monitor/conf/${open_ips_conf_2} ${ipaddr}
				if [[ $? != "0" ]]
				then
					arbitration_log ERROR "SET_ALL_LOCATION" "This is 3 nodes mode, Set primary 2nd location ip failed."
					$(create_check_file 255)
					exit 1
				fi
			fi
        else
            sudo -u arbiter bash ${MONITOR_HOME}/script/etcd-client.sh --set /monitor/conf/${open_ips_conf_2} ${ipaddr}
            if [[ $? != "0" ]]
            then
                arbitration_log ERROR "SET_ALL_LOCATION" "Set primary location ip failed."
                $(create_check_file 255)
                exit 1
            fi
        fi
    fi
    
    
    if [[ ${isSlaver} == "true" ]]
    then
        if [[ ${Slavercount} -eq 1 ]]
        then
            sudo -u arbiter bash ${MONITOR_HOME}/script/etcd-client.sh --set /monitor/conf/${close_ips_conf_1} ${ipaddr}
            if [[ $? != "0" ]]
            then
                arbitration_log ERROR "SET_ALL_LOCATION" "Set primary location ip failed."
                $(create_check_file 255)
                exit 1
            fi
			if [[ ${slave_node_ips_list_length} -eq 1 ]]
			then
				sudo -u arbiter bash ${MONITOR_HOME}/script/etcd-client.sh --set /monitor/conf/${close_ips_conf_2} ${ipaddr}
				if [[ $? != "0" ]]
				then
					arbitration_log ERROR "SET_ALL_LOCATION" "This is 3 nodes mode, Set primary 2nd location ip failed."
					$(create_check_file 255)
					exit 1
				fi
			fi
        else
            sudo -u arbiter bash ${MONITOR_HOME}/script/etcd-client.sh --set /monitor/conf/${close_ips_conf_2} ${ipaddr}
            if [[ $? != "0" ]]
            then
                arbitration_log ERROR "SET_ALL_LOCATION" "Set primary location ip failed."
                $(create_check_file 255)
                exit 1
            fi
        fi
    fi
    $(create_check_file 100)
    arbitration_log INFO "SET_ALL_LOCATION" "Set primary location successfully."
}

function main()
{
    rm -f /opt/arbitration_file/check_allnodes_result.sh
    set_aamonitor_version
    set_allnodes_location
}

main