#!/bin/bash
set +x

declare -i LOG_MAX_SIZE=5*1024*1024
declare -i LOG_MAX_NUM=20
umask 027
#const value of different loglevel
CON_ERROR="0"
CON_WARN="1"
CON_INFO="2"
CON_DEBUG="3"

#set default log level 
DEFAULT_LEVEL="2"
LOG_LEVEL=${DEFAULT_LEVEL}

function gettime()
{
    echo "$(date -d 'today' '+%Y-%m-%d %H:%M:%S')"
}

function getuser()
{
    echo "the local user $(whoami)($(id -u))"
}

function LOG()
{
    if [ ! -d $(dirname ${LOG_FILE}) ]; then
        mkdir -p $(dirname ${LOG_FILE})
    fi
    
    local progname=$(basename ${BASH_SOURCE[2]})
    local severity=$1
    local line_no=$2
    shift 2
    local logmsg=$@

    local level=""
    
    if [ ${severity} -le ${LOG_LEVEL} ]; then
        case ${severity} in
            0)  # Error log
                level="ERROR"
                ;;
            1)  # Warning log
                level="WARN "
                ;;
            2)  # Information log
                level="INFO "
                ;;
            3)  # Debug log
                level="DEBUG"
                ;;
            *)  # Any other logs
                level="     "
                ;;
        esac
    fi
    
    if [ -f $LOG_FILE ]; then
        chmod 640 $LOG_FILE
        local logsize=$(ls -l ${LOG_FILE} | awk '{print $5}')
        if [ $logsize -ge $LOG_MAX_SIZE ]; then
            local datetime=$(date -d 'today' '+%Y%m%d%H%M%S')
            mv $LOG_FILE "${LOG_FILE}.${datetime}"
        chmod 440 "${LOG_FILE}.${datetime}"
        fi
        
        local lognum=$(ls -l $LOG_FILE* | wc -l)
        if [ $lognum -gt $LOG_MAX_NUM ]; then
            local oldestlogfile=$(ls $LOG_FILE* | sort | sed -n '2p')
            rm -rf ${oldestlogfile} 
        fi
    fi
    
    echo "[$(gettime)] [$$] [${level}] [${progname} ${line_no}] [$(getuser)] ${logmsg}" >> ${LOG_FILE}
    return 0
}

function g_LOG_Error()
{
    LOG $CON_ERROR $BASH_LINENO "$@"
    return 0
}

function g_LOG_Warn()
{
    LOG $CON_WARN $BASH_LINENO "$@"
    return 0
}

function g_LOG_Info()
{
    LOG $CON_INFO $BASH_LINENO "$@"
    return 0
}

function g_LOG_Debug()
{
    LOG $CON_DEBUG $BASH_LINENO "$@"
    return 0
}
