#!/bin/bash
set +x

xuser=$(id -un)
if [ "${xuser}" != "arbiter" ]
then
  echo "please login as arbiter, then excute the script again."
  exit 1
fi

function getWorkPath()
{
    dir=$(dirname "$0")
    ispointstart=$(echo "${dir}"|awk -F/ '{print $1}')
    if [ "${ispointstart}" == "." ]
    then
        dir=$(echo "${dir}"|sed 's/^.//')
        curPath="$(pwd)${dir}"
    elif [ "${ispointstart}" == ".." ]
    then
        curPath="$(pwd)/${dir}"
    else
        curPath="${dir}"
    fi
    return 0
}
getWorkPath
. "${curPath}"/../env/env.properties

. /etc/profile > /dev/null 2>&1
TMOUT=0

rootDir=$(echo $(cd "$(dirname "$0")"; pwd))
. $rootDir/logging.sh
LOG_FILE="${MONITOR_LOG}/service.log"

PROCESS_NAME="arbitration-monitor_${INDEX}"
ALARM_PROCESS_NAME="arbitration-monitor-alarm"
BASE_DIR="${MONITOR_HOME}"
LIB_DIR="${MONITOR_HOME}/lib/"
CONF_DIR="${MONITOR_HOME}/conf/"
PROP_FILE="${MONITOR_HOME}/conf/aam.properties"
PID_FILE="${MONITOR_HOME}/arbitration-monitor.pid"


JAVA_OPTS="-Dprocess.name=$PROCESS_NAME -Dbase.dir=$BASE_DIR -Xss256k -Xms128M -Xmx128M"
JAVA_OPTS="$JAVA_OPTS -Djava.nio.channels.spi.SelectorProvider=sun.nio.ch.EPollSelectorProvider"
JAVA_OPTS="$JAVA_OPTS -Dbeetle.application.home.path=$CONF_DIR -Dlog4j.configurationFile=$CONF_DIR/log4j2.xml -Dlog4j2.formatMsgNoLookups=true"
JAVA_OPTS="$JAVA_OPTS -XX:+UnlockExperimentalVMOptions -XX:+UseG1GC -XX:G1PeriodicGCLoadThreshold=20"
JAVA_OPTS="$JAVA_OPTS -XX:G1PeriodicGCInterval=3000 -XX:+G1Uncommit"
JAVA_OPTS="$JAVA_OPTS -XX:CompileCommand=exclude,org.springframework.core.ResolvableType::forMethodParameter"
cat "${PROP_FILE}" | grep aam.local.ip | grep "]" > /dev/null 2>&1
if [ $? -ne 0 ]
then
   JAVA_OPTS="$JAVA_OPTS -Djava.net.preferIPv4Stack=true -Djava.net.preferIPv4Addresses=true"
fi
LOCAL_JAR=`ls $LIB_DIR | sed "s|^|$LIB_DIR|" | tr '\n' ':'`
JAVA_CP=$CLASSPATH:$LOCAL_JAR:$CONF_DIR
JAVA_MAIN="com.huawei.aamonitor.server.AAMonitor"

function kill_process()
{
    kill_single_process "${PROCESS_NAME}"
    if [ "${INDEX}" = "0" ];then
        kill_single_process "arbitration-monitor"
    fi
}

function kill_single_process()
{
    process_name="$1"
    local pid=$(ps -efww | grep -w "Dprocess.name=${process_name}" | grep -v grep | awk '{print $2}')
    local num=$(ps -efww | grep -w "Dprocess.name=${process_name}" | grep -v grep | wc -l)
    if [ $num -eq 0 ]
    then
        g_LOG_Info "the arbitration-monitor process already stoped."
    elif [ $num -eq 1 ]
    then
        #use systemd to stop this process
        g_LOG_Info "find one arbitration-monitor process, pid=${pid}."
        kill -9 $pid >> ${LOG_FILE} 2>&1
        sleep 2
    else
        g_LOG_Warn "find one more arbitration-monitor process, pid=${pid}."
        #force stop all process
        kill -9 $pid >> ${LOG_FILE} 2>&1
        sleep 2
    fi
}

function do_start()
{
    g_LOG_Info "begin to start arbitration-monitor ..."
    
    sed  -i 's/start.mode=false/start.mode=true/' $PROP_FILE
    
    kill_process

    export CIPHER_ROOT=${COMMON_HOME}/cipher
    export OSS_ROOT=${MONITOR_HOME}
    export MONITOR_ROOT=${BASE_DIR};
    export ETCD_ROOT=${ETCD_HOME};
    export OSS_ROOT=${BASE_DIR};

    ${ARBITRATION_JAVA_HOME}/bin/java $JAVA_OPTS -cp $JAVA_CP $JAVA_MAIN > /dev/null 2>&1 &
    if [ $? -ne 0 ]
    then
        g_LOG_Error "start arbitration-monitor failed."
        return 1
    fi

    sleep 2

    pid=$(ps -efww | grep "Dprocess.name=${PROCESS_NAME}" | grep -v grep | awk '{print $2}')
    if [ "x${pid}" = "x" ]
    then
        g_LOG_Error "query arbitration-monitor process pid failed."
        return 1
    else
        g_LOG_Info "start arbitration-monitor process with pid=${pid}."
        echo $pid > $PID_FILE
    fi

    g_LOG_Info "start arbitration-monitor success."
    return 0
}

function do_stop()
{
    g_LOG_Info "begin to stop arbitration-monitor ..."
    sed  -i 's/start.mode=true/start.mode=false/' $PROP_FILE
    
    kill_process
    g_LOG_Info "stop arbitration-monitor success."
    return 0
}

function do_restart()
{
    g_LOG_Info "begin to restart arbitration-monitor ..."
    kill_process
    if [ $? -ne 0 ]
    then
        return 1
    fi
    g_LOG_Info "stop arbitration-monitor success."
    
    sleep 1
    
    do_start
    if [ $? -ne 0 ]
    then
        return 1
    fi
    
    g_LOG_Info "restart arbitration-monitor success."
    return 0
}

case "$1" in
    start)
        echo -n "Starting arbitration-monitor daemon ... "
        do_start
        exit $?
        ;;
    stop)
        echo -n "Stoping arbitration-monitor daemon ... "
        do_stop
        exit $?
        ;;
    restart)
        echo -n "Restarting arbitration-monitor daemon ... "
        do_restart
        exit $?
        ;;
    *)
        echo "Usage: $0 {start|stop|restart}"
        exit 1
        ;;
esac
